/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.sa.handler;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.exception.NotRoleException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.sinozg.applet.common.core.model.ErrorMsgInfo;
import cn.sinozg.applet.common.utils.MsgUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=-2147483648)
public class SaGlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(SaGlobalExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={NotLoginException.class})
    public void nonLoginException(HttpServletRequest request, HttpServletResponse response, NotLoginException e) {
        log.error("\u672a\u6388\u6743\uff01\uff01{}", (Object)request.getHeader("User-Agent"));
        String errorMsg = e.getMessage();
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            errorMsg = StringUtils.substringBefore((String)errorMsg, (String)"\uff1a");
        }
        ErrorMsgInfo.Builder builder = new ErrorMsgInfo.Builder("BIZ000100017", (Exception)e, request, response, new Object[]{errorMsg}).closeCause();
        MsgUtil.httpError((HttpStatus)HttpStatus.UNAUTHORIZED, (ErrorMsgInfo.Builder)builder);
    }

    @ResponseBody
    @ExceptionHandler(value={NotPermissionException.class, NotRoleException.class})
    public void forbidden(HttpServletRequest request, HttpServletResponse response, SaTokenException e) {
        String errorMsg = e.getMessage();
        log.error("\u6ca1\u6709\u6743\u9650\uff01\uff01{}", (Object)errorMsg);
        MsgUtil.httpError((HttpStatus)HttpStatus.FORBIDDEN, (ErrorMsgInfo.Builder)new ErrorMsgInfo.Builder("BIZ000100034", (Exception)e, request, response));
    }
}

