/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.sa.plugin;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.json.SaJsonTemplate;
import cn.dev33.satoken.plugin.SaTokenPlugin;
import cn.dev33.satoken.stp.StpInterface;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.SnowFlake;
import cn.sinozg.applet.common.utils.UserUtil;
import java.util.List;
import java.util.Map;

/**
 * 序列化插件
 * @Description
 * @Copyright Copyright (c) 2025
 * @author xyb
 * @since 2025-03-25 22:18:54
*/
public class SaPlugin implements SaTokenPlugin {

    @Override
    public void install() {
        // token 生成器
        SaStrategy.instance.createToken = (id, type) -> SnowFlake.genId();
        SaManager.setSaTokenDao(new SaRedisJackson());
        SaManager.setSaJsonTemplate(new SaJacksonTemplate());
        SaManager.setStpInterface(new SaStpInterface());
    }

    /**
     * 数据转化器
     * @Description
     * @Copyright Copyright (c) 2025
     * @author xyb
     * @since 2025-03-29 14:04:45
    */
    private static class SaJacksonTemplate implements SaJsonTemplate {
        @Override
        public String objectToJson(Object obj) {
            return JsonUtil.toJson(obj);
        }

        @Override
        public <T> T jsonToObject(String json, Class<T> type) {
            return JsonUtil.toPojo(json, type);
        }

        @Override
        public Map<String, Object> jsonToMap(String json) {
            return JsonUtil.toMap(json);
        }
    }

    /**
     * 接口权限
     * @Description
     * @Copyright Copyright (c) 2025
     * @author xyb
     * @since 2025-03-29 14:03:38
    */
    private static class SaStpInterface implements StpInterface {
        /**
         * 获取权限集合
         * @param loginId 登录id
         * @param loginType 登录类型
         * @return 权限集合
         */
        @Override
        public List<String> getPermissionList(Object loginId, String loginType) {
            return UserUtil.userPermission();
        }

        /**
         * 获取角色集合
         * @param loginId 登录id
         * @param loginType 登录类型
         * @return 角色集合
         */
        @Override
        public List<String> getRoleList(Object loginId, String loginType) {
            return UserUtil.userRole();
        }
    }
}
