/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.sa.service.impl;

import cn.sinozg.applet.common.config.RedisConfig;
import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.service.AuthStorageService;
import cn.sinozg.applet.common.utils.PojoUtil;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"app.login.token-database"})
public class AuthStorageCustomizeServiceImpl
implements AuthStorageService {
    @Resource
    private AppValue appValue;
    @Resource
    private LettuceConnectionFactory defaultFactory;
    private RedisTemplate<String, Object> redisTemplate;
    private static final Logger log = LoggerFactory.getLogger(AuthStorageCustomizeServiceImpl.class);

    public <T> T getCacheObject(String key) {
        Object o = this.redis().opsForValue().get((Object)key);
        return (T)PojoUtil.cast((Object)o);
    }

    public void setCacheObject(String key, Object value, long timeout) {
        if (timeout > 0L) {
            this.redis().opsForValue().set((Object)key, value, timeout, TimeUnit.SECONDS);
        } else {
            this.redis().opsForValue().set((Object)key, value);
        }
    }

    public void deleteObject(String key) {
        this.redis().delete((Object)key);
    }

    public long objExpireTime(String key) {
        Long l = this.redis().getExpire((Object)key);
        return l == null ? 0L : l;
    }

    public void expire(String key, long timeout, TimeUnit unit) {
        this.redis().expire((Object)key, timeout, unit);
    }

    public Collection<String> keys(String pattern) {
        return this.redis().keys((Object)pattern);
    }

    private RedisTemplate<String, Object> redis() {
        if (this.redisTemplate == null) {
            this.redisTemplate = this.createTemplate();
        }
        return this.redisTemplate;
    }

    private RedisTemplate<String, Object> createTemplate() {
        RedisSentinelConfiguration sc;
        RedisSentinelConfiguration sentinelConfiguration = this.defaultFactory.getSentinelConfiguration();
        int database = this.appValue.getLogin().getTokenDatabase();
        if (sentinelConfiguration != null) {
            RedisSentinelConfiguration sentinelConfig = new RedisSentinelConfiguration();
            sentinelConfig.setDatabase(database);
            sentinelConfig.setUsername(sentinelConfiguration.getUsername());
            sentinelConfig.setPassword(sentinelConfiguration.getPassword());
            sentinelConfig.setSentinels((Iterable)sentinelConfiguration.getSentinels());
            sc = sentinelConfig;
        } else {
            RedisStandaloneConfiguration standaloneConfiguration = this.defaultFactory.getStandaloneConfiguration();
            RedisStandaloneConfiguration standaloneConfig = new RedisStandaloneConfiguration();
            standaloneConfig.setHostName(standaloneConfiguration.getHostName());
            standaloneConfig.setPort(standaloneConfiguration.getPort());
            standaloneConfig.setPassword(standaloneConfiguration.getPassword());
            standaloneConfig.setUsername(standaloneConfiguration.getUsername());
            standaloneConfig.setDatabase(database);
            sc = standaloneConfig;
        }
        LettuceConnectionFactory factory = new LettuceConnectionFactory((RedisConfiguration)sc, this.defaultFactory.getClientConfiguration());
        factory.afterPropertiesSet();
        return RedisConfig.setRedisConfig((LettuceConnectionFactory)factory);
    }
}

