package cn.sinozg.applet.common.core.base;

import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;


/**
 * 请求基类
 *
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-14 下午 09:34
 **/
public class BaseRequest<T> {
    /** 请求参数 */
    @Valid
    @NotNull(message = "{TIRSCI.BaseRequest.params}")
    @Schema(description = "请求参数")
    private T params;

    /**
     * 获取 请求参数
     *
     * @return params 请求参数
     */
    public T getParams() {
      return this.params;
    }

    /**
     * 设置 请求参数
     *
     * @param params 请求参数
     */
    public void setParams(T params) {
      this.params = params;
    }
}
