package cn.sinozg.applet.common.service;

import org.springframework.web.servlet.config.annotation.InterceptorRegistry;

/**
 * 初始化系统相关的信息
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-25 下午 02:44
 **/
public interface FrameworkInitDataService {

    /**
     * 缓存信息
     */
    void cacheSystemData ();

    /**
     * 需要初始化的信息
     */
    void initSystemInfo();

    /**
     * 项目启动后 需要 PostConstruct的值
     */
    void postConstruct ();

    /**
     * 项目自定义的拦截器
     * @param registry InterceptorRegistry对象
     */
    void addCustomInterceptor (InterceptorRegistry registry);
}
