package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.model.LoginUserVo;
import cn.sinozg.applet.common.service.FrameworkUserService;

import java.util.List;

/**
* 用户信息
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 10:06
**/
public class UserUtil {

    private static final FrameworkUserService SERVICE = SpringUtil.getBean(FrameworkUserService.class);

    /**
     * 获取用户角色id信息
     * @return 角色集合
     */
    public static List<String> userRole (){
        return user().getRoles();
    }

    /**
     * 获取用户权限id
     * @return 权限集合
     */
    public static List<String> userPermission (){
        return user().getPermissions();
    }

    /**
     * 用户名称
     * @return 用户名称
     */
    public static String userName (){
        return user().getUserName();
    }

    /**
     * 获取部门名称
     * @return 部门名称
     */
    public static String deptName (){
        return user().getDeptName();
    }

    /**
     * 用户id 主键
     * @return 用户id 逻辑主键
     */
    public static String uid (){
        return user().getId();
    }
    /**
     * 用户id 腾讯的用户id
     * @return 用户id
     */
    @Deprecated
    public static String userId (){
        return user().getUserId();
    }

    /**
     * 刷新用户缓存
     */
    public static void refreshUser (){
        SERVICE.refreshUserInfo();
    }

    /**
     * 用户信息
     * @return 用户信息对象
     */
    public static LoginUserVo user (){
        return SERVICE.userInfo();
    }

    /**
     * 获取用户消息
     * @param token token
     * @param uid uid
     * @return 用户消息
     */
    public static LoginUserVo user (String token, String uid){
        return SERVICE.getUserInfo(token, uid);
    }

    /**
     * 获取租户id
     * @return 租户id
     */
    public static String tenantId () {
        return user().getTenantId();
    }
}
