/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.config;

import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.BaseConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RedissonClient.class})
public class RedissonConfig {
    @Resource
    private RedisProperties properties;

    @Bean
    public RedissonClient redissonClient() {
        Config config = new Config();
        RedisProperties.Cluster cluster = this.properties.getCluster();
        if (cluster != null && cluster.getNodes() != null) {
            ClusterServersConfig servers = config.useClusterServers();
            for (String nodeAddress : cluster.getNodes()) {
                servers.addNodeAddress(new String[]{this.prefixAddress(nodeAddress, null)});
            }
            this.setPassword((BaseConfig<?>)servers);
        } else {
            SingleServerConfig single = config.useSingleServer();
            single.setDatabase(this.properties.getDatabase());
            single.setAddress(this.prefixAddress(this.properties.getHost(), this.properties.getPort()));
            this.setPassword((BaseConfig<?>)single);
        }
        return Redisson.create((Config)config);
    }

    private void setPassword(BaseConfig<?> baseConfig) {
        if (StringUtils.isNotBlank((CharSequence)this.properties.getPassword())) {
            baseConfig.setPassword(this.properties.getPassword());
        }
    }

    @NotNull
    private String prefixAddress(String host, Integer port) {
        StringBuilder address = new StringBuilder("redis://");
        address.append(host);
        if (port != null) {
            address.append(":").append(port);
        }
        return address.toString();
    }
}

