/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.holder;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MdcContextHolder {
    private static final Logger log = LoggerFactory.getLogger(MdcContextHolder.class);
    private static final ThreadLocal<Map<String, String>> MDC_HOLDER = new TransmittableThreadLocal<Map<String, String>>(){

        protected void beforeExecute() {
            Map map = (Map)this.get();
            map.forEach(MDC::put);
        }

        protected void afterExecute() {
            MDC.clear();
        }

        protected Map<String, String> initialValue() {
            return new HashMap<String, String>(16);
        }
    };

    public static void put(String traceId) {
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = UUID.randomUUID().toString().replace("-", "");
        }
        MDC.put((String)"traceId", (String)traceId);
        MDC_HOLDER.get().put("traceId", traceId);
    }

    public static String get() {
        return MDC.get((String)"traceId");
    }

    public static void clear() {
        MDC.clear();
        MDC_HOLDER.get().clear();
        MDC_HOLDER.remove();
    }
}

