/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.config.SystemConfig;
import cn.sinozg.applet.common.core.model.DictDataVo;
import cn.sinozg.applet.common.enums.DictType;
import cn.sinozg.applet.common.holder.UserContextHolder;
import cn.sinozg.applet.common.utils.I18nUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.RedisUtil;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DictUtil {
    private DictUtil() {
    }

    public static void setDictCache(Map<String, List<DictDataVo>> data) {
        RedisUtil.setCacheObjectBatch(data, DictUtil.dictKeyFun(), Duration.ofMinutes(30L));
    }

    public static String getDictLabel(DictType dictType, String dictValue) {
        return DictUtil.getDictLabel(dictType, dictValue, ",");
    }

    public static String getDictValue(DictType dictType, String dictLabel) {
        return DictUtil.getDictValue(dictType, dictLabel, ",");
    }

    public static String getDictLabel(DictType dictType, String dictValue, String separator) {
        return DictUtil.tran(dictType, dictValue, separator, true);
    }

    public static String getDictValue(DictType dictType, String dictLabel, String separator) {
        return DictUtil.tran(dictType, dictLabel, separator, false);
    }

    private static String tran(DictType dictType, String text, String separator, boolean value) {
        separator = StringUtils.trimToEmpty((String)separator);
        List<DictDataVo> list = DictUtil.getDictCache(dictType);
        Object[] texts = StringUtils.split((String)text, (String)separator);
        if (CollectionUtils.isEmpty(list) || ArrayUtils.isEmpty((Object[])texts)) {
            return null;
        }
        Locale locale = SystemConfig.APP.getLogin().isI18n() ? UserContextHolder.getLocale() : null;
        Map map = PojoUtil.toMap(list, d -> value ? d.getDictValue() : DictUtil.dictLabel(d, locale), d -> !value ? d.getDictValue() : DictUtil.dictLabel(d, locale));
        StringBuilder names = new StringBuilder();
        for (Object t : texts) {
            String v = (String)map.get(t);
            if (!StringUtils.isNotBlank((CharSequence)v)) continue;
            names.append(v).append(separator);
        }
        return StringUtils.stripEnd((String)names.toString(), (String)separator);
    }

    public static void clearDictCache() {
        Collection<String> keys = RedisUtil.keys(DictUtil.getCacheKey("*"));
        RedisUtil.deleteObject(keys);
    }

    private static String dictLabel(DictDataVo dictData, Locale locale) {
        if (locale == null) {
            return dictData.getDictLabel();
        }
        return I18nUtil.getDictName(dictData, locale);
    }

    public static List<DictDataVo> getDictCache(DictType key) {
        Object cacheObj = RedisUtil.getCacheObject(DictUtil.getCacheKey(key.getCode()));
        return (List)PojoUtil.cast(cacheObj);
    }

    public static String getCacheKey(String dictType) {
        return DictUtil.dictKeyFun().apply(dictType);
    }

    public static Function<String, String> dictKeyFun() {
        return k -> "jby:biz:dict:" + k;
    }
}

