/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.base.BasePageResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import cn.sinozg.applet.common.utils.MsgUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.function.BiConsumer;

public class PageConvert {
    private PageConvert() {
    }

    public static <T, R> BasePageResponse<List<T>> convert(BasePageResponse<List<R>> sources, Class<T> clazz, BiConsumer<R, T> consumer) {
        BasePageResponse<List<List>> response = new BasePageResponse<List<List>>();
        response.setPage(sources.getPage());
        List data = PojoUtil.copyList((List)((List)sources.getData()), clazz, consumer);
        response.setData(data);
        return response;
    }

    public static <T, R> BasePageResponse<List<T>> convert(BasePageResponse<List<R>> sources, Class<T> clazz) {
        return PageConvert.convert(sources, clazz, null);
    }

    public static <T> BasePageResponse<List<T>> convert(PagingRequest pagingRequest, List<T> data, Long total) {
        return MsgUtil.page(pagingRequest, null, (m, n) -> {
            long pageSize = pagingRequest.getPageSize();
            long pages = total / pageSize;
            if (total % pageSize != 0L) {
                ++pages;
            }
            Page p = new Page(pagingRequest.getPageNum().longValue(), pageSize);
            p.setRecords(data);
            p.setTotal(total.longValue());
            p.setPages(pages);
            return p;
        });
    }
}

