package cn.sinozg.applet.common.core.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
* 分页响应信息
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 09:36
**/
public class PagingResponse {

    /** 总页数 */
    @Schema(description = "总页数")
    private long pages;
    /** 当前页数 */
    @JsonProperty("pageNum")
    @Schema(description = "当前页数")
    private long pageNum;
    /** 每页的数量 */
    @JsonProperty("pageSize")
    @Schema(description = "每页数量")
    private long pageSize;
    /** 总数量 */
    @JsonProperty("totalNum")
    @Schema(description = "总数量")
    private long totalNum;

    /**
     * 获取 总页数
     *
     * @return pages 总页数
     */
    public long getPages() {
        return this.pages;
    }

    /**
     * 设置 总页数
     *
     * @param pages 总页数
     */
    public void setPages(long pages) {
        this.pages = pages;
    }

    /**
     * 获取 当前页数
     *
     * @return pageNum 当前页数
     */
    public long getPageNum() {
        return this.pageNum;
    }

    /**
     * 设置 当前页数
     *
     * @param pageNum 当前页数
     */
    public void setPageNum(long pageNum) {
        this.pageNum = pageNum;
    }

    /**
     * 获取 每页的数量
     *
     * @return pageSize 每页的数量
     */
    public long getPageSize() {
        return this.pageSize;
    }

    /**
     * 设置 每页的数量
     *
     * @param pageSize 每页的数量
     */
    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * 获取 总数量
     *
     * @return totalNum 总数量
     */
    public long getTotalNum() {
        return this.totalNum;
    }

    /**
     * 设置 总数量
     *
     * @param totalNum 总数量
     */
    public void setTotalNum(long totalNum) {
        this.totalNum = totalNum;
    }
}
