package cn.sinozg.applet.common.core.base;

import io.swagger.v3.oas.annotations.media.Schema;


/**
 * 请求基类
 * 分页使用
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-14 下午 09:34
 **/
public class BasePageRequest<T> extends BaseRequest<T> {
    /** 分页对象 */
    @Schema(description = "分页对象")
    private PagingRequest page;

    /**
     * 获取 分页对象
     *
     * @return page 分页对象
     */
    public PagingRequest getPage() {
      return this.page;
    }

    /**
     * 设置 分页对象
     *
     * @param page 分页对象
     */
    public void setPage(PagingRequest page) {
      this.page = page;
    }
}
