package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.base.BasePageResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;
import java.util.function.BiConsumer;


/**
* 封装分页 转化
* @Author: xyb
* @Description: 
* @Date: 2022-11-14 下午 10:04
**/
public class PageConvert {
    private PageConvert(){
    }
    /**
     * 分页对象转化 自定义转化过程
     * 将一个类型的分页结果 转为另外一个类型
     * @param sources 原始分页结果
     * @param clazz 被转化类型
     * @param consumer 转化过程的方法 将原始数据处理 为需要变更的数据过程
     * @param <T> 被转化类型
     * @param <R> 原始类型
     * @return 结果集
     */
    public static <T, R> BasePageResponse<List<T>> convert(BasePageResponse<List<R>> sources, Class<T> clazz, BiConsumer<R, T> consumer){
        BasePageResponse<List<T>> response = new BasePageResponse<>();
        response.setPage(sources.getPage());
        List<T> data = PojoUtil.copyList(sources.getData(), clazz, consumer);
        response.setData(data);
        return response;
    }

    /**
     * 分页对象转化
     * 将一个类型的分页结果 转为另外一个类型
     * @param sources 原始分页结果
     * @param clazz 被转化类型
     * @return 新的结果集
     * @param <T> 被转化类型
     * @param <R> 原始类型
     */
    public static <T, R> BasePageResponse<List<T>> convert(BasePageResponse<List<R>> sources, Class<T> clazz) {
        return convert(sources, clazz, null);
    }

    /**
     * 转为分页结果
     * @param pagingRequest 分页请求
     * @param data 数据集合
     * @param total 数据总数
     * @return 结果集
     * @param <T> 类型
     */
    public static <T> BasePageResponse<List<T>> convert(PagingRequest pagingRequest, List<T> data, Long total){
        return MsgUtil.page(pagingRequest, null, (m, n) -> {
            long pageSize = pagingRequest.getPageSize();
            long pages = total / pageSize;
            if (total % pageSize != 0) {
                pages ++;
            }
            Page<T> p = new Page<>(pagingRequest.getPageNum(), pageSize);
            p.setRecords(data);
            p.setTotal(total);
            p.setPages(pages);
            return p;
        });
    }
}
