/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.config.SystemConfig;
import cn.sinozg.applet.common.core.model.AesRsaEncrypt;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.JsonUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class CypherUtil {
    public static final String AES_ALGORITHM = "AES";
    public static final String RSA_ALGORITHM = "RSA";
    private static final String PKCS7 = "AES/CBC/PKCS7Padding";
    private static final BCryptPasswordEncoder ENCODER = new BCryptPasswordEncoder();
    private static final Logger log = LoggerFactory.getLogger(CypherUtil.class);

    private CypherUtil() {
    }

    public static boolean signature(boolean sha2, String signature, String ... params) {
        if (StringUtils.isBlank((CharSequence)signature)) {
            log.error("\u975e\u6cd5\u8bf7\u6c42\u53c2\u6570\uff0c\u6709\u90e8\u5206\u53c2\u6570\u4e3a\u7a7a : {}", (Object)signature);
            return false;
        }
        String source = CypherUtil.signMessage(sha2, params);
        return signature.equals(source);
    }

    public static String signMessage(boolean sha2, String ... params) {
        if (StringUtils.isAnyEmpty((CharSequence[])params)) {
            log.error("\u975e\u6cd5\u8bf7\u6c42\u53c2\u6570\uff0c\u6709\u90e8\u5206\u53c2\u6570\u4e3a\u7a7a : {}", (Object)Arrays.toString(params));
            return null;
        }
        Arrays.sort(params);
        String source = StringUtils.join((Object[])params);
        source = sha2 ? DigestUtils.sha256Hex((String)source) : DigestUtils.sha1Hex((String)source);
        return source;
    }

    public static String wxDecrypt(String encryptedData, String sessionKey, String iv) {
        boolean flag;
        byte[] eds = Base64.decodeBase64((String)encryptedData);
        byte[] sks = Base64.decodeBase64((String)sessionKey);
        byte[] ivs = Base64.decodeBase64((String)iv);
        int base = 16;
        boolean bl = flag = sks.length % base != 0;
        if (flag) {
            int groups = sks.length / base + 1;
            byte[] temp = new byte[groups * base];
            Arrays.fill(temp, (byte)0);
            System.arraycopy(sks, 0, temp, 0, sks.length);
            sks = temp;
        }
        byte[] original = CypherUtil.doFinalAes(PKCS7, true, eds, sks, ivs);
        String json = "";
        if (ArrayUtils.isNotEmpty((byte[])original)) {
            json = new String(original, StandardCharsets.UTF_8);
        }
        return json;
    }

    public static String encoder(String rawPassword) {
        return ENCODER.encode((CharSequence)rawPassword);
    }

    public static boolean matches(CharSequence rawPassword, String encodedPassword) {
        return ENCODER.matches(rawPassword, encodedPassword);
    }

    public static String md5Upper(String input) {
        return CypherUtil.md5(input).toUpperCase();
    }

    public static String md5(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return "";
        }
        return DigestUtils.md5Hex((String)input);
    }

    public static byte[] decryptJson(String content, String rsaPrivateKey, String aesKey) throws Exception {
        Key privateKey = CypherUtil.rsaKey(rsaPrivateKey, false);
        byte[] aesKeyBytes = CypherUtil.decrypt(RSA_ALGORITHM, privateKey, aesKey);
        SecretKeySpec key = new SecretKeySpec(aesKeyBytes, AES_ALGORITHM);
        return CypherUtil.decrypt(AES_ALGORITHM, key, content);
    }

    public static Object encrypt(HttpServletRequest request, Object data) throws IOException {
        if (SystemConfig.APP.getSign().isRsaEnable()) {
            String jsPublicKey = StringUtils.trimToEmpty((String)request.getHeader("Whj-Pub-Key"));
            String json = JsonUtil.toJson((Object)data);
            if (json == null) {
                throw new RuntimeException("\u51fa\u53c2\u8f6cjson\u9519\u8bef\uff01");
            }
            try {
                return CypherUtil.encrypt(json, jsPublicKey);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return data;
    }

    private static AesRsaEncrypt encrypt(String content, String rsaPublicKey) throws Exception {
        String aesKey = CypherUtil.getAesKey();
        String json = CypherUtil.encrypt(AES_ALGORITHM, new SecretKeySpec(aesKey.getBytes(), AES_ALGORITHM), content);
        Key publicKey = CypherUtil.rsaKey(rsaPublicKey, true);
        String encryptAesKey = CypherUtil.encrypt(RSA_ALGORITHM, publicKey, aesKey);
        AesRsaEncrypt encrypt = new AesRsaEncrypt();
        encrypt.setData(json);
        encrypt.setAesKey(encryptAesKey);
        return encrypt;
    }

    public static Key rsaKey(String key, boolean isPublic) throws Exception {
        byte[] bytes = Base64.decodeBase64((String)key);
        KeyFactory factory = KeyFactory.getInstance(RSA_ALGORITHM);
        Key rsaKey = isPublic ? factory.generatePublic(new X509EncodedKeySpec(bytes)) : factory.generatePrivate(new PKCS8EncodedKeySpec(bytes));
        return rsaKey;
    }

    public static byte[] decrypt(String transformation, Key key, String input) {
        byte[] params = Base64.decodeBase64((String)input);
        if (AES_ALGORITHM.equals(transformation)) {
            return CypherUtil.doFinalAes(transformation, true, params, key);
        }
        return CypherUtil.doFinalRsa(transformation, 2, key, params);
    }

    public static String encrypt(String transformation, Key key, String input) {
        byte[] params = input.getBytes();
        byte[] encryptBytes = AES_ALGORITHM.equals(transformation) ? CypherUtil.doFinalAes(transformation, false, params, key) : CypherUtil.doFinalRsa(transformation, 1, key, params);
        return Base64.encodeBase64String((byte[])encryptBytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] doFinalRsa(String transformation, int opMode, Key key, byte[] input) {
        int inputLen = input.length;
        int offSet = 0;
        int i = 0;
        int maxLength = 1 == opMode ? 117 : 128;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(opMode, key);
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > maxLength ? cipher.doFinal(input, offSet, maxLength) : cipher.doFinal(input, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * maxLength;
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.error("RSA \u7b7e\u540d\u9519\u8bef\uff01", (Throwable)e);
            throw new CavException("BIZ000100031");
        }
    }

    public static byte[] doFinalAes(String transformation, boolean decrypt, byte[] input, Key aesKey) {
        return CypherUtil.doFinalAes(transformation, decrypt, input, null, null, aesKey);
    }

    public static byte[] doFinalAes(String transformation, boolean decrypt, byte[] input, byte[] aesKey, byte[] ivKey) {
        return CypherUtil.doFinalAes(transformation, decrypt, input, aesKey, ivKey, null);
    }

    private static byte[] doFinalAes(String transformation, boolean decrypt, byte[] input, byte[] aesKey, byte[] ivKey, Key aesPriKey) {
        boolean flag;
        boolean bl = flag = input == null || aesKey == null && aesPriKey == null;
        if (flag) {
            throw new CavException("BIZ000100030");
        }
        try {
            Cipher cipher = Cipher.getInstance(transformation);
            if (aesPriKey != null) {
                cipher.init(decrypt ? 2 : 1, aesPriKey);
            } else {
                SecretKeySpec keySpec = new SecretKeySpec(aesKey, AES_ALGORITHM);
                if (ivKey == null) {
                    ivKey = Arrays.copyOfRange(aesKey, 0, 16);
                }
                AlgorithmParameters params = AlgorithmParameters.getInstance(AES_ALGORITHM);
                params.init(new IvParameterSpec(ivKey));
                cipher.init(decrypt ? 2 : 1, keySpec);
            }
            return cipher.doFinal(input);
        }
        catch (Exception e) {
            log.error("AES \u7b7e\u540d\u9519\u8bef\uff01", (Throwable)e);
            throw new CavException("BIZ000100029");
        }
    }

    private static String getAesKey() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(AES_ALGORITHM);
        kg.init(128);
        SecretKey key = kg.generateKey();
        return Base64.encodeBase64String((byte[])key.getEncoded());
    }

    public static KeyPair getKeyPair() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA_ALGORITHM);
        keyPairGenerator.initialize(1024);
        return keyPairGenerator.generateKeyPair();
    }
}

