/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.FileUtil;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DowUtil {
    private static final Logger log = LoggerFactory.getLogger(DowUtil.class);

    public static void download(HttpServletResponse response, String fileName, byte[] bs, Consumer<BufferedOutputStream> consumer) {
        DowUtil.setResponse(response, fileName, bs);
        try (ServletOutputStream os = response.getOutputStream();
             BufferedOutputStream bos = new BufferedOutputStream((OutputStream)os);){
            if (bs != null) {
                bos.write(bs);
            }
            if (consumer != null) {
                consumer.accept(bos);
            }
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u8d44\u6e90\u9519\u8bef\u3002", (Throwable)e);
            throw new CavException("BIZ000100023");
        }
    }

    public static void setResponse(HttpServletResponse response, String fileName, byte[] bs) {
        String charset = StandardCharsets.UTF_8.name();
        response.reset();
        response.setCharacterEncoding(charset);
        response.setHeader("Content-Encoding", charset);
        response.setContentType(FileUtil.fileType((String)fileName));
        if (bs != null) {
            response.setIntHeader("Content-Length", bs.length);
        }
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, charset));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

