/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.model.DictDataVo;
import cn.sinozg.applet.common.core.model.I18nName;
import cn.sinozg.applet.common.enums.DictType;
import cn.sinozg.applet.common.holder.UserContextHolder;
import cn.sinozg.applet.common.utils.DictUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class I18nUtil {
    private I18nUtil() {
    }

    public static String getDictName(I18nName i18nName) {
        return I18nUtil.getDictName(i18nName, null);
    }

    public static String getDictName(DictDataVo cb) {
        return I18nUtil.getDictName(cb, null);
    }

    public static String getDictName(DictDataVo cb, Locale locale) {
        I18nName i18nName = cb.getI18nLabel();
        return I18nUtil.getDictName(i18nName, locale);
    }

    public static String getDictName(DictType type, String code) {
        return I18nUtil.getDictName(null, type, code);
    }

    public static String getDictName(Locale locale, DictType type, String code) {
        List<I18nName> list = I18nUtil.names(type, code);
        StringBuffer names = new StringBuffer();
        if (locale == null) {
            locale = UserContextHolder.getLocale();
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (I18nName n : list) {
                String temp;
                if (StringUtils.isNotBlank((CharSequence)names)) {
                    names.append(",");
                }
                if (!StringUtils.isNotBlank((CharSequence)(temp = I18nUtil.getDictName(n, locale)))) continue;
                names.append(temp);
            }
        }
        return names.toString();
    }

    public static String getDictName(DictType type, String code, String language) {
        Locale locale = new Locale(language);
        return I18nUtil.getDictName(locale, type, code);
    }

    public static String getDictName(I18nName i18nName, Locale locale) {
        if (i18nName == null) {
            return null;
        }
        if (locale == null) {
            locale = UserContextHolder.getLocale();
        }
        if (Locale.US.equals(locale)) {
            return i18nName.getEnName();
        }
        return i18nName.getName();
    }

    public static I18nName i18nName(DictType type, String code) {
        List<I18nName> list = I18nUtil.names(type, code);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public static Map<String, I18nName> nameByType(DictType type) {
        HashMap<String, I18nName> map = new HashMap<String, I18nName>(64);
        List<DictDataVo> list = DictUtil.getDictCache(type);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(c -> map.put(c.getDictValue(), c.getI18nLabel()));
        }
        return map;
    }

    private static List<I18nName> names(DictType type, String code) {
        if (StringUtils.isBlank((CharSequence)code) || type == null) {
            return null;
        }
        Object[] codes = StringUtils.split((String)code, (String)",");
        Map<String, I18nName> map = I18nUtil.nameByType(type);
        if (ArrayUtils.isEmpty((Object[])codes) || MapUtils.isEmpty(map)) {
            return null;
        }
        ArrayList<I18nName> names = new ArrayList<I18nName>();
        for (Object c : codes) {
            names.add(map.get(c));
        }
        return names;
    }

    public static String locale() {
        Locale locale = UserContextHolder.getLocale();
        return locale.toString();
    }
}

