/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.utils.PojoUtil;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public final class SpringUtil
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static ConfigurableListableBeanFactory beanFactory;
    private static ApplicationContext context;

    public void postProcessBeanFactory(@NotNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        SpringUtil.beanFactory = beanFactory;
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public static <T> T getBean(String name) throws BeansException {
        if (beanFactory.containsBean(name)) {
            return (T)PojoUtil.cast((Object)beanFactory.getBean(name));
        }
        return null;
    }

    public static <T> T getBean(Class<T> clazz) throws BeansException {
        return (T)beanFactory.getBean(clazz);
    }

    public static boolean containsBean(String name) {
        return beanFactory.containsBean(name);
    }

    public static boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return beanFactory.isSingleton(name);
    }

    public static Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return beanFactory.getType(name);
    }

    public static String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        return beanFactory.getAliases(name);
    }

    public static <T> T getAopProxy(T invoker) {
        return (T)PojoUtil.cast((Object)AopContext.currentProxy());
    }

    public static String[] getActiveProfiles() {
        return context.getEnvironment().getActiveProfiles();
    }

    public static String getActiveProfile() {
        Object[] activeProfiles = SpringUtil.getActiveProfiles();
        return ArrayUtils.isNotEmpty((Object[])activeProfiles) ? activeProfiles[0] : null;
    }

    public static <T> Map<String, T> beansOfType(Class<T> clazz) {
        return context.getBeansOfType(clazz);
    }

    public static <T> T beanOfNmTp(String name, Class<T> clazz) {
        return (T)context.getBean(name, clazz);
    }

    public static <T> T registerBean(String beanName, Class<T> clazz, Object ... args) {
        if (SpringUtil.containsBean(beanName)) {
            T t = SpringUtil.getBean(beanName);
            if (t.getClass().isAssignableFrom(clazz)) {
                return t;
            }
            throw new RuntimeException("\u91cd\u590d\u7684bean " + beanName);
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (Object arg : args) {
                builder.addConstructorArgValue(arg);
            }
        }
        AbstractBeanDefinition definition = builder.getRawBeanDefinition();
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)context;
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)applicationContext.getBeanFactory();
        registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
        return SpringUtil.getBean(beanName);
    }
}

