package cn.sinozg.applet.common.core.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
* 请求响应信息基类 分页返回
* @Author: xyb
* @Description: 
* @Date: 2022-11-14 下午 09:35
**/
public class BasePageResponse<T> extends BaseResponse<T> {
	/** 分页信息 */
	@JsonProperty("page")
	@Schema(description = "分页信息")
	private PagingResponse page;

	/**
	 * 获取 分页信息
	 *
	 * @return page 分页信息
	 */
	public PagingResponse getPage() {
		return this.page;
	}

	/**
	 * 设置 分页信息
	 *
	 * @param page 分页信息
	 */
	public void setPage(PagingResponse page) {
		this.page = page;
	}
}
