package cn.sinozg.applet.common.properties;

import java.util.List;

/**
* 鉴权 路由配置
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 09:41
**/
public class ApiUrlValue {
    /** 授权拦截 */
    private List<String> authPatterns;
    /** 授权白名单 */
    private List<String> authExcludePath;

    /** 请求拦截 */
    private List<String> paramsPatterns;

    /** 将请求包装的 地址 默认本地所有 */
    private String wrapperUrl;

    /** 是否启用包装http请求 **/
    private boolean wrapperEnable = false;

    /**
     * 获取 授权拦截
     *
     * @return authPatterns 授权拦截
     */
    public List<String> getAuthPatterns() {
        return this.authPatterns;
    }

    /**
     * 设置 授权拦截
     *
     * @param authPatterns 授权拦截
     */
    public void setAuthPatterns(List<String> authPatterns) {
        this.authPatterns = authPatterns;
    }

    /**
     * 获取 授权白名单
     *
     * @return authExcludePath 授权白名单
     */
    public List<String> getAuthExcludePath() {
        return this.authExcludePath;
    }

    /**
     * 设置 授权白名单
     *
     * @param authExcludePath 授权白名单
     */
    public void setAuthExcludePath(List<String> authExcludePath) {
        this.authExcludePath = authExcludePath;
    }

    /**
     * 获取 请求拦截
     *
     * @return paramsPatterns 请求拦截
     */
    public List<String> getParamsPatterns() {
        return this.paramsPatterns;
    }

    /**
     * 设置 请求拦截
     *
     * @param paramsPatterns 请求拦截
     */
    public void setParamsPatterns(List<String> paramsPatterns) {
        this.paramsPatterns = paramsPatterns;
    }

    /**
     * 获取 将请求包装的 地址 默认本地所有
     *
     * @return wrapperUrl 将请求包装的 地址 默认本地所有
     */
    public String getWrapperUrl() {
        return this.wrapperUrl;
    }

    /**
     * 设置 将请求包装的 地址 默认本地所有
     *
     * @param wrapperUrl 将请求包装的 地址 默认本地所有
     */
    public void setWrapperUrl(String wrapperUrl) {
        this.wrapperUrl = wrapperUrl;
    }

    /**
     * 获取 是否启用包装http请求
     *
     * @return wrapperEnable 是否启用包装http请求
     */
    public boolean isWrapperEnable() {
        return this.wrapperEnable;
    }

    /**
     * 设置 是否启用包装http请求
     *
     * @param wrapperEnable 是否启用包装http请求
     */
    public void setWrapperEnable(boolean wrapperEnable) {
        this.wrapperEnable = wrapperEnable;
    }
}
