package cn.sinozg.applet.common.utils;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

/**
 * JavaBean web 相关工具类
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-05 17:12
 */
public class PojoWebUtil {


    /**
     * 批量分批次新增 或者修改数据
     * 先把数据按照 500 分成多批次
     * 再从数据库根据联合主键查询数据，转成联合主键为key 对象为value的map
     * 再把集合遍历 分为更新的集合 和 修改的集合
     * 再分别批次更新或者修改
     * @param list 原始数据
     * @param function 查询数据库的方法 通过list 参数返回一个map对象
     * @param isUpdFun 判断是否为新增的数据 如果是修改需要再函数里设置主键
     * @param service service对象
     * @param <T> 实体类型
     * @param <S> service
     */
    public static <T, S extends ServiceImpl<?, T>> Map<String, T> batchAddOrUpdate (List<T> list, Function<List<T>, Map<String, T>> function, BiFunction<T, Map<String, T>, Boolean> isUpdFun, S service){
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Map<String, T> map = new HashMap<>(64);
        List<Map<String, T>> partitions = PojoUtil.batchList(list, function);
        if (CollectionUtils.isNotEmpty(partitions)) {
            partitions.forEach(map::putAll);
        }
        List<T> insertList = new ArrayList<>();
        List<T> updateList = new ArrayList<>();
        list.forEach(l -> {
            boolean isUpdate = isUpdFun.apply(l, map);
            if (isUpdate) {
                updateList.add(l);
            } else {
                insertList.add(l);
            }
        });
        if (CollectionUtils.isNotEmpty(insertList)) {
            service.saveBatch(insertList);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            service.updateBatchById(updateList);
        }
        return map;
    }


    /**
     * 从 aop里面获取到 注解
     * @param joinPoint joinPoint
     * @param clazz 注解类型
     * @return 注解对象
     * @param <T> 注解对象类型
     */
    public static <T extends Annotation> T getAnnotation(JoinPoint joinPoint, Class<T> clazz){
        T t = joinPoint.getTarget().getClass().getAnnotation(clazz);
        if (t == null) {
            Signature signature = joinPoint.getSignature();
            MethodSignature methodSignature = (MethodSignature) signature;
            Method method = methodSignature.getMethod();
            t = method.getAnnotation(clazz);
        }
        return t;
    }

}
