package cn.sinozg.applet.common.properties;

/**
 * 小程序相关配置
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-22 下午 03:03
 **/
public class WechatValue {
    /** 消息token */
    private String msgToken;

    /** 私钥地址 */
    private String privateKeyPath;
    /** appid */
    private String appid;
    /** secret */
    private String secret;

    /** apiV3Key */
    private String apiV3Key;


    /**小程序商户号ID*/
    private String mchId;

    /** 证书序列号 */
    private String mchSerialNo;

    /**是否开启沙箱测试*/
    private boolean sandboxSignKeyFlag = false;

    /**沙箱测试密钥获取url*/
    private String sandboxNewUrl;

    /** authUrl 获取用户信息的接口 */
    private String authUrl;

    /**微信预支付地址*/
    private String unifiedOrderUrl = "https://api.mch.weixin.qq.com/v3/pay/transactions/jsapi";
    /**支付回调地址*/
    private String notifyUrl;

    /** 退款地址 */
    private String refundUrl = "https://api.mch.weixin.qq.com/v3/refund/domestic/refunds";
    /** 退款回调接口地址 */
    private String refundCallbackUrl;

    /** 关闭订单接口 */
    private String closeUrl = "https://api.mch.weixin.qq.com/v3/pay/transactions/out-trade-no/%s/close";

    /**
     * 获取 消息token
     *
     * @return msgToken 消息token
     */
    public String getMsgToken() {
        return this.msgToken;
    }

    /**
     * 设置 消息token
     *
     * @param msgToken 消息token
     */
    public void setMsgToken(String msgToken) {
        this.msgToken = msgToken;
    }

    /**
     * 获取 私钥地址
     *
     * @return privateKeyPath 私钥地址
     */
    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    /**
     * 设置 私钥地址
     *
     * @param privateKeyPath 私钥地址
     */
    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    /**
     * 获取 appid
     *
     * @return appid appid
     */
    public String getAppid() {
        return this.appid;
    }

    /**
     * 设置 appid
     *
     * @param appid appid
     */
    public void setAppid(String appid) {
        this.appid = appid;
    }

    /**
     * 获取 secret
     *
     * @return secret secret
     */
    public String getSecret() {
        return this.secret;
    }

    /**
     * 设置 secret
     *
     * @param secret secret
     */
    public void setSecret(String secret) {
        this.secret = secret;
    }

    /**
     * 获取 apiV3Key
     *
     * @return apiV3Key apiV3Key
     */
    public String getApiV3Key() {
        return this.apiV3Key;
    }

    /**
     * 设置 apiV3Key
     *
     * @param apiV3Key apiV3Key
     */
    public void setApiV3Key(String apiV3Key) {
        this.apiV3Key = apiV3Key;
    }

    /**
     * 获取 小程序商户号ID
     *
     * @return mchId 小程序商户号ID
     */
    public String getMchId() {
        return this.mchId;
    }

    /**
     * 设置 小程序商户号ID
     *
     * @param mchId 小程序商户号ID
     */
    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    /**
     * 获取 证书序列号
     *
     * @return mchSerialNo 证书序列号
     */
    public String getMchSerialNo() {
        return this.mchSerialNo;
    }

    /**
     * 设置 证书序列号
     *
     * @param mchSerialNo 证书序列号
     */
    public void setMchSerialNo(String mchSerialNo) {
        this.mchSerialNo = mchSerialNo;
    }

    /**
     * 获取 是否开启沙箱测试
     *
     * @return sandboxSignKeyFlag 是否开启沙箱测试
     */
    public boolean isSandboxSignKeyFlag() {
        return this.sandboxSignKeyFlag;
    }

    /**
     * 设置 是否开启沙箱测试
     *
     * @param sandboxSignKeyFlag 是否开启沙箱测试
     */
    public void setSandboxSignKeyFlag(boolean sandboxSignKeyFlag) {
        this.sandboxSignKeyFlag = sandboxSignKeyFlag;
    }

    /**
     * 获取 沙箱测试密钥获取url
     *
     * @return sandboxNewUrl 沙箱测试密钥获取url
     */
    public String getSandboxNewUrl() {
        return this.sandboxNewUrl;
    }

    /**
     * 设置 沙箱测试密钥获取url
     *
     * @param sandboxNewUrl 沙箱测试密钥获取url
     */
    public void setSandboxNewUrl(String sandboxNewUrl) {
        this.sandboxNewUrl = sandboxNewUrl;
    }

    /**
     * 获取 authUrl 获取用户信息的接口
     *
     * @return authUrl authUrl 获取用户信息的接口
     */
    public String getAuthUrl() {
        return this.authUrl;
    }

    /**
     * 设置 authUrl 获取用户信息的接口
     *
     * @param authUrl authUrl 获取用户信息的接口
     */
    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    /**
     * 获取 微信预支付地址
     *
     * @return unifiedOrderUrl 微信预支付地址
     */
    public String getUnifiedOrderUrl() {
        return this.unifiedOrderUrl;
    }

    /**
     * 设置 微信预支付地址
     *
     * @param unifiedOrderUrl 微信预支付地址
     */
    public void setUnifiedOrderUrl(String unifiedOrderUrl) {
        this.unifiedOrderUrl = unifiedOrderUrl;
    }

    /**
     * 获取 支付回调地址
     *
     * @return notifyUrl 支付回调地址
     */
    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    /**
     * 设置 支付回调地址
     *
     * @param notifyUrl 支付回调地址
     */
    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    /**
     * 获取 退款地址
     *
     * @return refundUrl 退款地址
     */
    public String getRefundUrl() {
        return this.refundUrl;
    }

    /**
     * 设置 退款地址
     *
     * @param refundUrl 退款地址
     */
    public void setRefundUrl(String refundUrl) {
        this.refundUrl = refundUrl;
    }

    /**
     * 获取 退款回调接口地址
     *
     * @return refundCallbackUrl 退款回调接口地址
     */
    public String getRefundCallbackUrl() {
        return this.refundCallbackUrl;
    }

    /**
     * 设置 退款回调接口地址
     *
     * @param refundCallbackUrl 退款回调接口地址
     */
    public void setRefundCallbackUrl(String refundCallbackUrl) {
        this.refundCallbackUrl = refundCallbackUrl;
    }

    /**
     * 获取 关闭订单接口
     *
     * @return closeUrl 关闭订单接口
     */
    public String getCloseUrl() {
        return this.closeUrl;
    }

    /**
     * 设置 关闭订单接口
     *
     * @param closeUrl 关闭订单接口
     */
    public void setCloseUrl(String closeUrl) {
        this.closeUrl = closeUrl;
    }
}