package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.config.SystemConfig;
import org.apache.commons.lang3.StringUtils;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-05 20:07
 */
public class StringUtil {
    private StringUtil(){
    }
    /**
     * 根据图片id转为直接显示的地址
     * @param picId 图片id
     * @return 显示地址
     */
    public static String showUrl (String picId){
        if (StringUtils.isEmpty(picId)) {
            return StringUtils.EMPTY;
        }
        return SystemConfig.APP.getFontUrl() + picId;
    }

    /**
     * 删除最后一个字符
     * @param input 参数
     */
    public static void delLast(StringBuilder input){
        if (input.length() > 0) {
            input.deleteCharAt(input.length() - 1);
        }
    }
}
