package cn.sinozg.applet.common.holder;

import cn.sinozg.applet.common.constant.BaseConstants;
import com.alibaba.ttl.TransmittableThreadLocal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * 存储 traceId 链路 跟踪 id
 * @Author: xyb
 * @Description:
 * @Date: 2023-05-10 下午 01:28
 **/
public class MdcContextHolder {
    private static final Logger log = LoggerFactory.getLogger(MdcContextHolder.class);
    /** traceId */
    private static final ThreadLocal<Map<String, String>> MDC_HOLDER = new TransmittableThreadLocal<Map<String, String>>() {
        @Override
        protected void beforeExecute() {
            final Map<String, String> map = get();
            map.forEach(MDC::put);
        }

        @Override
        protected void afterExecute() {
            MDC.clear();
        }

        @Override
        protected Map<String, String> initialValue() {
            return new HashMap<>(16);
        }
    };

    /**
     * 设置mdc信息
     * @param traceId traceId
     */
    public static void put(String traceId){
        if (StringUtils.isBlank(traceId)) {
            traceId = UUID.randomUUID().toString().replace(BaseConstants.MIDDLE_LINE, StringUtils.EMPTY);
        }
        MDC.put(BaseConstants.TRACE_ID, traceId);
        MDC_HOLDER.get().put(BaseConstants.TRACE_ID, traceId);
    }

    /**
     * 获取到链路 id
     * @return 链路 id
     */
    public static String get(){
        return MDC.get(BaseConstants.TRACE_ID);
    }
    /**
     * 清除上下文数据
     */
    public static void clear() {
        MDC.clear();
        MDC_HOLDER.get().clear();
        MDC_HOLDER.remove();
    }
}