package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.base.BasePageResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
* <p>封装分页信息</p>
 * <pre> {@code
* PageUtil<ResponseData, RequestData> pu = (p, q) -> mapper.pageList(p, q);
* BasePageResponse<List<ResponseData>> result = pu.page(request.getPage(), params);
* }</pre>
 * @Author: xyb
* @Description: 
* @Date: 2022-11-14 下午 10:04
**/
@FunctionalInterface
public interface PageUtil<T, R> {

	/**
	 *  封装分页对象
	 * @param info 分页对象
	 * @param r 参数
	 * @return 查询集合
	 */
    default BasePageResponse<List<T>> page(PagingRequest info, R r){
        return MsgUtil.page(info, r, this::queryPage);
    }

    /**
     * 获取数据集合
     * @param page 分页对象
     * @param r 参数
     * @return 结果集
     */
    IPage<T> queryPage(Page<T> page, R r);
}
