/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.holder;

import cn.sinozg.applet.common.core.model.LoginUserVo;
import cn.sinozg.applet.common.core.model.UserThreadInfo;
import cn.sinozg.applet.common.service.FrameworkAuthService;
import cn.sinozg.applet.common.utils.SpringUtil;
import cn.sinozg.applet.common.utils.UserUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserContextHolder {
    private static final Logger log = LoggerFactory.getLogger(UserContextHolder.class);
    private static final ThreadLocal<Locale> LOCALE_HOLDER = new TransmittableThreadLocal();
    private static final ThreadLocal<UserThreadInfo> CONTEXT_OLDER = new TransmittableThreadLocal();
    private static final FrameworkAuthService AUTH_SERVICE = SpringUtil.getBean(FrameworkAuthService.class);

    public static void setInfo(HttpServletRequest request) {
        Locale locale = UserContextHolder.localByRequest(request);
        LoginUserVo user = UserUtil.user();
        if (user != null) {
            String token = AUTH_SERVICE.token();
            UserContextHolder.setInfo(user.getId(), token, user.getTenantId());
        }
        LOCALE_HOLDER.set(locale);
    }

    public static void setInfo(String uid, String token, String tenantId) {
        UserThreadInfo info = new UserThreadInfo();
        info.setUid(uid);
        info.setToken(token);
        info.setTenantId(tenantId);
        CONTEXT_OLDER.set(info);
    }

    public static void setTenantId(String tenantId) {
        UserThreadInfo user = CONTEXT_OLDER.get();
        if (user == null) {
            user = new UserThreadInfo();
            user.setTenantId(tenantId);
        }
        CONTEXT_OLDER.set(user);
    }

    public static String getTenantId() {
        UserThreadInfo user = CONTEXT_OLDER.get();
        if (user != null) {
            return user.getTenantId();
        }
        return null;
    }

    public static Locale getLocale() {
        return UserContextHolder.getLocale(WebUtil.request());
    }

    public static Locale getLocale(HttpServletRequest request) {
        Locale locale = LOCALE_HOLDER.get();
        if (locale == null) {
            UserContextHolder.setInfo(request);
            locale = LOCALE_HOLDER.get();
        }
        return locale;
    }

    public static UserThreadInfo getInfo() {
        return CONTEXT_OLDER.get();
    }

    public static void clear() {
        CONTEXT_OLDER.remove();
        LOCALE_HOLDER.remove();
    }

    private static Locale localByRequest(HttpServletRequest request) {
        String headerValue;
        if (request != null && StringUtils.isNotBlank((CharSequence)(headerValue = request.getHeader("Accept-Language")))) {
            String acceptLanguage = headerValue.split(",")[0];
            Object[] languages = null;
            if (StringUtils.contains((CharSequence)acceptLanguage, (CharSequence)"-")) {
                languages = acceptLanguage.split("-");
            }
            if (StringUtils.contains((CharSequence)acceptLanguage, (CharSequence)" ")) {
                languages = acceptLanguage.split("_");
            }
            int languageLength = 2;
            if (ArrayUtils.isNotEmpty((Object[])languages) && languages.length == languageLength) {
                return new Locale((String)languages[0], (String)languages[1]);
            }
        }
        return Locale.CHINA;
    }

    public static void setLocale(String language) {
        String[] languages = language.contains(" ") ? language.split("_") : language.split("-");
        Locale locale = new Locale(languages[0], languages[1]);
        LOCALE_HOLDER.set(locale);
    }
}

