package cn.sinozg.applet.common.core.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
* 请求响应信息基类
* @Author: xyb
* @Description: 
* @Date: 2022-11-14 下午 09:35
**/
public class BaseResponse<T> {
	/**
	 * 交易状态
	 * 00-成功
	 * 01-失败
	 */
	@JsonProperty("bizStatus")
	@Schema(description = "交易状态;00-成功 01-失败")
	private String bizStatus;

	/** 链路 跟踪 id */
	@JsonProperty("traceId")
	@Schema(description = "链路 跟踪 id")
	private String traceId;
	
	/** 错误信息描述 */
	@JsonProperty("errorInfo")
	@Schema(description = "错误信息描述")
	private ErrorInfo errorInfo;
	/** 业务数据 */
	@JsonProperty("data")
	@Schema(description = "业务数据")
	private T data;

	/**
	 * 获取 交易状态  00-成功  01-失败
	 *
	 * @return bizStatus 交易状态  00-成功  01-失败
	 */
	public String getBizStatus() {
		return this.bizStatus;
	}

	/**
	 * 设置 交易状态  00-成功  01-失败
	 *
	 * @param bizStatus 交易状态  00-成功  01-失败
	 */
	public void setBizStatus(String bizStatus) {
		this.bizStatus = bizStatus;
	}

	/**
	 * 获取 链路 跟踪 id
	 *
	 * @return traceId 链路 跟踪 id
	 */
	public String getTraceId() {
		return this.traceId;
	}

	/**
	 * 设置 链路 跟踪 id
	 *
	 * @param traceId 链路 跟踪 id
	 */
	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	/**
	 * 获取 错误信息描述
	 *
	 * @return errorInfo 错误信息描述
	 */
	public ErrorInfo getErrorInfo() {
		return this.errorInfo;
	}

	/**
	 * 设置 错误信息描述
	 *
	 * @param errorInfo 错误信息描述
	 */
	public void setErrorInfo(ErrorInfo errorInfo) {
		this.errorInfo = errorInfo;
	}

	/**
	 * 获取 业务数据
	 *
	 * @return data 业务数据
	 */
	public T getData() {
		return this.data;
	}

	/**
	 * 设置 业务数据
	 *
	 * @param data 业务数据
	 */
	public void setData(T data) {
		this.data = data;
	}
}
