package cn.sinozg.applet.common.service;

import org.springframework.web.servlet.HandlerInterceptor;

/**
 * 鉴权
 * @Description
 * @Copyright Copyright (c) 2024
 * @author xieyubin
 * @since 2024-01-05 17:03:03
 */
public interface FrameworkAuthService {

    /**
     * 获取到token 无异常
     * @return token
     */
    String token ();

    /**
     * 获取到token 不处理异常
     * @return token
     */
    String tokenWithException ();

    /**
     * 当前登录id 无异常
     * @return 登录id
     */
    String loginId ();

    /**
     * 通过token 等到当前用户id
     * @param token token
     * @return 登录id
     */
    String loginIdByToken(String token);

    /**
     * 通过登录id获取到token
     * @param id 登录id
     * @return token
     */
    String tokenById (String id);

    /**
     * 登录后处理
     * @param id 登录id
     */
    void login(String id);

    /**
     * 登出
     * @param tokenId token
     */
    void logout(String tokenId);

    /**
     * 强制登出
     * @param tokenId token
     */
    void kickOutByTokenValue(String tokenId);

    /**
     * token 失效时间
     * @return 失效时间
     */
    long tokenTimeOut();

    /**
     * 获取权限拦截器
     * @return 拦截器
     */
    HandlerInterceptor authInterceptor();
}
