package cn.sinozg.applet.common.service;

import cn.sinozg.applet.common.core.model.LoginUserVo;

/**
* 系统登录鉴权 用户信息接口
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 09:44
**/
public interface FrameworkUserService {

    /**
     * 强刷用户信息缓存
     * @return 用户信息
     */
    LoginUserVo refreshUserInfo();

    /**
     * 缓存里面获取到用户信息
     * @return 用户信息
     */
    LoginUserVo userInfo ();

    /**
     * 设置用户信息到缓存里面
     * @param token token
     * @param uid 用户id
     * @param user 用户信息
     * @return 用户信息
     */
    LoginUserVo setUserInfo (String token, String uid, LoginUserVo user);

    /**
     * 获取用户信息到缓存里面
     * @param token token
     * @param uid 用户id
     * @return 用户信息
     */
    LoginUserVo getUserInfo (String token, String uid);
}
