package cn.sinozg.applet.common.config;

import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.BaseConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import jakarta.annotation.Resource;

/**
 * Redisson 配置
 * 有redisson的jar包才加载
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-27 下午 09:52
 **/
@Configuration
@ConditionalOnClass(value = {RedissonClient.class})
public class RedissonConfig {

    @Resource
    private RedisProperties properties;

    @Bean
    public RedissonClient redissonClient() {
        Config config = new Config();
        // 判断是否为集群
        RedisProperties.Cluster cluster = properties.getCluster();
        if (cluster != null && cluster.getNodes() != null) {
            ClusterServersConfig servers = config.useClusterServers();
            for (String nodeAddress : cluster.getNodes()) {
                servers.addNodeAddress(prefixAddress(nodeAddress, null));
            }
            setPassword(servers);
        } else {
            SingleServerConfig single = config.useSingleServer();
            single.setDatabase(properties.getDatabase());
            single.setAddress(prefixAddress(properties.getHost(), properties.getPort()));
            setPassword(single);
        }
        return Redisson.create(config);
    }

    private void setPassword (BaseConfig<?> baseConfig){
        if (StringUtils.isNotBlank(properties.getPassword())) {
            baseConfig.setPassword(properties.getPassword());
        }
    }
    @NotNull
    private String prefixAddress(String host, Integer port) {
        StringBuilder address = new StringBuilder("redis://");
        address.append(host);
        if (port != null) {
            address.append(":").append(port);
        }
        return address.toString();
    }
}