package cn.sinozg.applet.common.config;

import cn.sinozg.applet.common.constant.OmConstants;
import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.service.FrameworkInitDataService;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.blueconic.browscap.BrowsCapField;
import com.blueconic.browscap.UserAgentParser;
import com.blueconic.browscap.UserAgentService;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.Arrays;

/**
* 系统静态参数
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 09:29
**/
@Component
public class SystemConfig {
    @Resource
    public AppValue appValue;
    @Resource
    public ObjectMapper objectMapper;
    @Resource
    private FrameworkInitDataService initDataService;

    public static final Logger log = LoggerFactory.getLogger(SystemConfig.class);
    /** 系统配置 */
    public static AppValue APP;

    /** 解析浏览器的信息 */
    public static UserAgentParser PARSER;

    @PostConstruct
    public void init(){
        OmConstants.setOm(objectMapper);
        // 设置mp 的序列化实现
        JacksonTypeHandler.setObjectMapper(objectMapper);
        APP = appValue;
        try {
            // 加载配置信息 有点慢 所以用静态变量
            PARSER = new UserAgentService()
                    .loadParser(
                            Arrays.asList(BrowsCapField.BROWSER, BrowsCapField.BROWSER_MAJOR_VERSION, BrowsCapField.PLATFORM, BrowsCapField.PLATFORM_VERSION));
        } catch (Exception ignored) {
        }
        initDataService.postConstruct();
    }
}
