package cn.sinozg.applet.common.core.base;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
* 实体类基类
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 09:34
**/
public abstract class BaseEntity implements Serializable {

    /** 备注 */
    @TableField(value = "remark")
    private String remark;
    /** 创建者 */
    @TableField(value = "created_by", fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    private String createdBy;
    /** 创建时间 */
    @TableField(value = "created_time", fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    private LocalDateTime createdTime;
    /** 更新者*/
    @TableField(value = "updated_by", fill = FieldFill.INSERT_UPDATE)
    private String updatedBy;
    /** 最后更新时间 */
    @TableField(value = "updated_time", fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updatedTime;

    /**
     * 获取 备注
     *
     * @return remark 备注
     */
    public String getRemark() {
        return this.remark;
    }

    /**
     * 设置 备注
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 获取 创建者
     *
     * @return createdBy 创建者
     */
    public String getCreatedBy() {
        return this.createdBy;
    }

    /**
     * 设置 创建者
     *
     * @param createdBy 创建者
     */
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    /**
     * 获取 创建时间
     *
     * @return createdTime 创建时间
     */
    public LocalDateTime getCreatedTime() {
        return this.createdTime;
    }

    /**
     * 设置 创建时间
     *
     * @param createdTime 创建时间
     */
    public void setCreatedTime(LocalDateTime createdTime) {
        this.createdTime = createdTime;
    }

    /**
     * 获取 更新者
     *
     * @return updatedBy 更新者
     */
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    /**
     * 设置 更新者
     *
     * @param updatedBy 更新者
     */
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    /**
     * 获取 最后更新时间
     *
     * @return updatedTime 最后更新时间
     */
    public LocalDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    /**
     * 设置 最后更新时间
     *
     * @param updatedTime 最后更新时间
     */
    public void setUpdatedTime(LocalDateTime updatedTime) {
        this.updatedTime = updatedTime;
    }
}
