package cn.sinozg.applet.common.utils;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import java.io.BufferedReader;
import java.io.IOException;

/**
 * http 相关的
 * @Author: xyb
 * @Description
 * @Date: 2021/9/12 12:40
 */
public class WebUtil {
    private static final Logger log = LoggerFactory.getLogger(WebUtil.class);
    private WebUtil(){
    }

    /**
     * 获取 HttpServletRequest
     * @return HttpServletRequest
     */
    public static HttpServletRequest request(){
        return attributes().getRequest();
    }

    /**
     * 获取 HttpServletResponse
     * @return HttpServletResponse
     */
    public static HttpServletResponse response(){
        return attributes().getResponse();
    }

    /**
     * Attribute的值
     * @param name name
     * @return Attribute的值
     * @param <T> Attribute类型
     */
    public static <T> T getAttribute (String name){
       return PojoUtil.cast(request().getAttribute(name));
    }

    /**
     * 设置值到Attribute
     * @param name name
     * @param o 值
     */
    public static void setAttribute (String name, Object o){
        request().setAttribute(name, o);
    }

    /**
     * ServletRequestAttributes
     * @return ServletRequestAttributes
     */
    private static ServletRequestAttributes attributes(){
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return (ServletRequestAttributes) attributes;
    }


    /**
     * 获取到请求里的 body
     * @param request 请求
     * @return 请求参数
     */
    public static String getBodyString(ServletRequest request) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = request.getReader()) {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        } catch (IOException e) {
            log.error("getBodyString出现问题！", e);
        }
        return sb.toString();
    }

    /**
     * 请求URL
     * @return URL
     */
    public static String getUrl() {
        HttpServletRequest request = request();
        return getDomain(request);
    }

    /**
     * 请求URL
     * @param request HttpServletRequest
     * @return 请求url
     */
    public static String getDomain(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String contextPath = request.getServletContext().getContextPath();
        return url.delete(url.length() - request.getRequestURI().length(), url.length()).append(contextPath).toString();
    }

}
