/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.base.BasePageResponse;
import cn.sinozg.applet.common.core.base.BaseRequest;
import cn.sinozg.applet.common.core.base.BaseResponse;
import cn.sinozg.applet.common.core.base.ErrorInfo;
import cn.sinozg.applet.common.core.base.PagingRequest;
import cn.sinozg.applet.common.core.base.PagingResponse;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.CypherUtil;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.SpringUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.LocaleResolver;

public class MsgUtil {
    private static final Logger log = LoggerFactory.getLogger(MsgUtil.class);
    private static final MessageSource MS = SpringUtil.getBean(MessageSource.class);
    private static final LocaleResolver LR = (LocaleResolver)SpringUtil.getBean("appletLocaleResolver");

    private MsgUtil() {
    }

    public static <T> T params(BaseRequest<T> request) {
        T t = request.getParams();
        if (t == null) {
            throw new CavException("BIZ000100000");
        }
        return t;
    }

    public static <T> BaseResponse<T> ok(T params) {
        BaseResponse<T> response = new BaseResponse<T>();
        response.setData(params);
        return response;
    }

    public static BaseResponse<String> ok() {
        return new BaseResponse<String>();
    }

    public static <T, R> BasePageResponse<List<T>> page(PagingRequest info, R r, BiFunction<Page<T>, R, IPage<T>> function) {
        BasePageResponse<List<List>> response = new BasePageResponse<List<List>>();
        if (info == null) {
            throw new CavException("BIZ000100001");
        }
        long pageSize = info.getPageSize();
        Page p = new Page(info.getPageNum().longValue(), pageSize);
        IPage<T> pageData = function.apply(p, r);
        PagingResponse page = new PagingResponse();
        page.setPageNum(pageData.getCurrent());
        page.setPages(pageData.getPages());
        page.setPageSize(pageSize);
        page.setTotalNum(pageData.getTotal());
        response.setPage(page);
        response.setData(pageData.getRecords());
        return response;
    }

    public static void httpError(HttpServletResponse response, HttpServletRequest request, Exception e, HttpStatus status, String code, Object ... params) {
        BaseResponse<String> result = MsgUtil.error(request, e, code, params);
        MsgUtil.writeJson(response, request, status, result);
    }

    public static void writeJson(HttpServletResponse response, HttpServletRequest request, HttpStatus status, Object data) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        if (status != null) {
            response.setStatus(status.value());
        }
        try (PrintWriter writer = response.getWriter();){
            Object o = CypherUtil.encrypt(request, data);
            writer.print(JsonUtil.toJson((Object)o));
        }
        catch (IOException ex) {
            log.error("response error", (Throwable)ex);
        }
    }

    public static BaseResponse<String> error(HttpServletRequest request, Exception e, String code, Object ... params) {
        String errorMassage = MsgUtil.error(request, code, params);
        BaseResponse<String> response = new BaseResponse<String>();
        response.setBizStatus("01");
        ErrorInfo r = new ErrorInfo();
        r.setCode(code);
        r.setMessage(errorMassage);
        r.setUrl(request.getRequestURI());
        MsgUtil.log(e, request);
        response.setErrorInfo(r);
        return response;
    }

    public static String error(HttpServletRequest request, CavException e) {
        if (request == null) {
            request = WebUtil.request();
        }
        return MsgUtil.error(request, e.getCode(), e.getParameters());
    }

    private static String error(HttpServletRequest request, String code, Object ... params) {
        Locale locale = LR != null ? LR.resolveLocale(request) : Locale.getDefault();
        return MS.getMessage(code, params, locale);
    }

    private static void log(Exception ex, HttpServletRequest request) {
        if (ex == null) {
            return;
        }
        log.error("************************\u5f02\u5e38\u5f00\u59cb*******************************");
        log.error("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)request.getRequestURL());
        Enumeration es = request.getParameterNames();
        log.error("\u8bf7\u6c42\u53c2\u6570");
        while (es.hasMoreElements()) {
            String key = (String)es.nextElement();
            log.error("{}-------{}", (Object)key, (Object)request.getParameter(key));
        }
        if (ex instanceof CavException) {
            CavException e = (CavException)ex;
            log.error("Error : {} {}", (Object)e.getCode(), (Object)e.getParameters());
        }
        log.error("Error DETAIL : ", (Throwable)ex);
        MsgUtil.printCause(ex.getCause(), ex.getStackTrace());
        log.error("************************\u5f02\u5e38\u7ed3\u675f*******************************");
    }

    private static void printCause(Throwable cause, StackTraceElement[] pste) {
        if (cause != null) {
            MsgUtil.printCause(cause.getStackTrace());
            MsgUtil.printCause(cause.getCause(), null);
        } else {
            MsgUtil.printCause(pste);
        }
    }

    private static void printCause(StackTraceElement[] ste) {
        if (ArrayUtils.isNotEmpty((Object[])ste)) {
            log.error("Cause by:");
            log.error(ste[0].toString());
        }
    }
}

