package cn.sinozg.applet.common.runner;

import cn.sinozg.applet.common.utils.SpringUtil;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;

/**
 * 设置 可配置的 动态定时任务
 * 配合注解 @RedissonLock 可实现分布式定时调度
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2023
 * @since 2023-10-12 14:37
 */
public abstract class BaseScheduling implements SchedulingConfigurer {
    /** 执行表达式 **/
    protected String cron;

    /** 实现类类型 **/
    protected Class<? extends BaseScheduling> clazz;

    /**
     * 设置必须要参数
     */
    public abstract void setParams ();

    /**
     * 执行对应的业务 可以使用注解实现分布式功能<p/>
     */
    public abstract void execute ();

    /**
     * <p>执行</p>
     * @param registrar registrar
     */
    @Override
    public void configureTasks(@NotNull ScheduledTaskRegistrar registrar) {
        initParams();
        BaseScheduling thisObj = SpringUtil.getBean(clazz);
        registrar.addTriggerTask(thisObj::execute,
                trigger -> {
                    initParams();
                    CronTrigger ct = new CronTrigger(cron);
                    return ct.nextExecution(trigger);
                });
    }

    /**
     * 先设置参数
     */
    private void initParams (){
        setParams();
        if (clazz == null || StringUtils.isBlank(cron)) {
            throw new RuntimeException("请先设置参数！");
        }
    }
}
