/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.SpringUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RegExUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.web.servlet.HandlerExceptionResolver;

public class PojoWebUtil {
    private PojoWebUtil() {
    }

    public static <T, S extends ServiceImpl<?, T>> Map<String, T> batchAddOrUpdate(List<T> list, Function<List<T>, Map<String, T>> function, BiFunction<T, Map<String, T>, Boolean> isUpdFun, S service) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        HashMap map = new HashMap(64);
        List partitions = PojoUtil.batchList(list, function);
        if (CollectionUtils.isNotEmpty((Collection)partitions)) {
            partitions.forEach(map::putAll);
        }
        ArrayList insertList = new ArrayList();
        ArrayList updateList = new ArrayList();
        list.forEach(l -> {
            boolean isUpdate = (Boolean)isUpdFun.apply(l, map);
            if (isUpdate) {
                updateList.add(l);
            } else {
                insertList.add(l);
            }
        });
        if (CollectionUtils.isNotEmpty(insertList)) {
            service.saveBatch(insertList);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            service.updateBatchById(updateList);
        }
        return map;
    }

    public static <T extends Annotation> T getAnnotation(JoinPoint joinPoint, Class<T> clazz) {
        T t = joinPoint.getTarget().getClass().getAnnotation(clazz);
        if (t == null) {
            Signature signature = joinPoint.getSignature();
            MethodSignature methodSignature = (MethodSignature)signature;
            Method method = methodSignature.getMethod();
            t = method.getAnnotation(clazz);
        }
        return t;
    }

    public static String methodKey(JoinPoint jp, String separator) {
        String className = jp.getTarget().getClass().getName();
        String name = RegExUtils.replacePattern((String)className, (String)"\\.", (String)"");
        return name + separator + jp.getSignature().getName();
    }

    public static String getElValue(JoinPoint jp, String key) {
        String regex = "^#.*.$";
        if (key.matches(regex)) {
            Method method = ((MethodSignature)jp.getSignature()).getMethod();
            StandardReflectionParameterNameDiscoverer u = new StandardReflectionParameterNameDiscoverer();
            Object[] params = u.getParameterNames(method);
            SpelExpressionParser parser = new SpelExpressionParser();
            StandardEvaluationContext context = new StandardEvaluationContext();
            if (ArrayUtils.isNotEmpty((Object[])params)) {
                for (int i = 0; i < params.length; ++i) {
                    context.setVariable((String)params[i], jp.getArgs()[i]);
                }
            }
            return (String)parser.parseExpression(key).getValue((EvaluationContext)context, String.class);
        }
        return key;
    }

    public static void resolveException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        HandlerExceptionResolver resolver = (HandlerExceptionResolver)SpringUtil.getBean("handlerExceptionResolver");
        if (resolver != null) {
            resolver.resolveException(request, response, null, e);
        }
    }
}

