/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.DowUtil;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    private static final int BUFFER = 1024;
    private static final Logger log = LoggerFactory.getLogger(ZipUtil.class);

    private ZipUtil() {
    }

    public static void exportZip(HttpServletResponse response, String sourceFilePath, String postfix) {
        String downloadName = System.currentTimeMillis() + postfix;
        try (ByteArrayOutputStream byteOs = ZipUtil.createZip(sourceFilePath);){
            byte[] data = byteOs.toByteArray();
            DowUtil.download(response, downloadName, data, null);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fazip\u6587\u4ef6\u9519\u8bef\uff0c", (Throwable)e);
            throw new CavException("\u5bfc\u51fazip\u6587\u4ef6\u9519\u8bef\uff01");
        }
    }

    public static void compress(String fromPath, String toPath) {
        File fromFile = new File(fromPath);
        File toFile = new File(toPath);
        if (!fromFile.exists()) {
            throw new RuntimeException(fromPath + "\u4e0d\u5b58\u5728\uff01");
        }
        try (FileOutputStream outputStream = new FileOutputStream(toFile);
             CheckedOutputStream checkedOutputStream = new CheckedOutputStream(outputStream, new CRC32());
             ZipOutputStream zipOutputStream = new ZipOutputStream(checkedOutputStream);){
            ZipUtil.compress(fromFile, zipOutputStream, "", true);
        }
        catch (Exception e) {
            log.error("\u538b\u7f29\u6587\u4ef6\u9519\u8bef\uff0c", (Throwable)e);
            throw new CavException("\u538b\u7f29\u6587\u4ef6\u9519\u8bef\uff01");
        }
    }

    private static ByteArrayOutputStream createZip(String sourceFilePath) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (CheckedOutputStream checkedOutputStream = new CheckedOutputStream(outputStream, new CRC32());
             ZipOutputStream zip = new ZipOutputStream(checkedOutputStream);){
            File file = new File(sourceFilePath);
            ZipUtil.compress(file, zip, "", true);
        }
        catch (Exception e) {
            log.error("\u521b\u5efazip\u6587\u4ef6\u9519\u8bef\uff0c", (Throwable)e);
            throw new CavException("\u521b\u5efazip\u6587\u4ef6\u9519\u8bef\uff01");
        }
        return outputStream;
    }

    private static void compress(File file, ZipOutputStream zipOut, String baseDir, boolean root) throws IOException {
        if (file.isDirectory()) {
            ZipUtil.compressDirectory(file, zipOut, baseDir, root);
        } else {
            ZipUtil.compressFile(file, zipOut, baseDir);
        }
    }

    private static void compressFile(File file, ZipOutputStream zipOut, String baseDir) throws IOException {
        if (!file.exists()) {
            return;
        }
        try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            int count;
            ZipEntry entry = new ZipEntry(baseDir + file.getName());
            zipOut.putNextEntry(entry);
            byte[] data = new byte[1024];
            while ((count = bis.read(data, 0, 1024)) != -1) {
                zipOut.write(data, 0, count);
            }
            zipOut.closeEntry();
            zipOut.flush();
        }
    }

    private static void compressDirectory(File dir, ZipOutputStream zipOut, String baseDir, boolean root) throws IOException {
        Object[] files = dir.listFiles();
        if (files != null && ArrayUtils.isNotEmpty((Object[])files)) {
            for (Object file : files) {
                String dirPath = root ? baseDir : baseDir + dir.getName() + File.separator;
                ZipUtil.compress((File)file, zipOut, dirPath, false);
            }
        }
    }
}

