/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.config.SystemConfig;
import cn.sinozg.applet.common.core.model.UserAgentInfo;
import cn.sinozg.applet.common.utils.HttpUtil;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.RedisUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import com.blueconic.browscap.Capabilities;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsUtil {
    private static final Logger log = LoggerFactory.getLogger(OsUtil.class);
    public static final String IP_URL = "http://whois.pconline.com.cn/ipJson.jsp?ip=%s&json=true";
    private static final String UNKNOWN = "Unknown";
    private static final String LOCAL_HOST = "127.0.0.1";

    private OsUtil() {
    }

    public static boolean isWindows() {
        String osName = System.getProperties().getProperty("os.name");
        return osName.toUpperCase().contains("WINDOWS");
    }

    public static String realAddressByIp(String ip) {
        String ipKey = String.format("jby:biz:ip:%s", StringUtils.replace((String)ip, (String)".", (String)"_"));
        String location = (String)RedisUtil.getCacheObject(ipKey);
        if (StringUtils.isBlank((CharSequence)location)) {
            location = OsUtil.getRealAddressByIp(ip);
            RedisUtil.setCacheObject(ipKey, location, Duration.ofDays(7L));
        }
        return location;
    }

    public static String getRealAddressByIp(String ip) {
        if (OsUtil.internalIp(ip)) {
            return "\u5185\u7f51IP";
        }
        try {
            byte[] bs = HttpUtil.getBytes((String)String.format(IP_URL, ip));
            if (bs == null) {
                log.error("\u8fdc\u7a0b\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e\u5f02\u5e38 {}", (Object)ip);
                return UNKNOWN;
            }
            String rspStr = new String(bs, Charset.forName("GBK"));
            Map map = (Map)PojoUtil.cast((Object)JsonUtil.toPojo((String)rspStr, Map.class));
            String region = MapUtils.getString((Map)map, (Object)"pro");
            String city = MapUtils.getString((Map)map, (Object)"city");
            String location = StringUtils.isAllBlank((CharSequence[])new CharSequence[]{region, city}) ? MapUtils.getString((Map)map, (Object)"addr") : String.format("%s %s", region, city);
            return StringUtils.trim((String)location);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e\u5f02\u5e38 {}", (Object)ip);
            return UNKNOWN;
        }
    }

    public static String getIpAddr() {
        return OsUtil.getIpAddr(WebUtil.request());
    }

    public static String getIpAddr(HttpServletRequest request) {
        CharSequence[] ips;
        String unknown = UNKNOWN;
        if (request == null) {
            return unknown;
        }
        String[] headers = new String[]{"x-forwarded-for", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_Client_IP", "HTTP_X_FORWARDED_FOR"};
        String ip = null;
        int max = headers.length + 1;
        for (int i = 0; i < max && (StringUtils.isEmpty(ip) || unknown.equalsIgnoreCase(ip)); ++i) {
            ip = i == headers.length ? request.getRemoteAddr() : request.getHeader(headers[i]);
        }
        int maxLen = 15;
        if (StringUtils.isNotEmpty(ip) && ip.length() > maxLen) {
            ip = StringUtils.substringBefore((String)ip, (String)",");
        }
        if (StringUtils.equalsAny((CharSequence)ip, (CharSequence[])(ips = new String[]{LOCAL_HOST, "0:0:0:0:0:0:0:1"}))) {
            ip = OsUtil.getHostIp();
        }
        return ip;
    }

    public static boolean internalIp(String ip) {
        byte[] addr = OsUtil.textToNumericFormatV4(ip);
        return OsUtil.internalIp(addr) || LOCAL_HOST.equals(ip);
    }

    private static boolean internalIp(byte[] addr) {
        int internalLength = 2;
        if (ArrayUtils.isEmpty((byte[])addr) || addr.length < internalLength) {
            return true;
        }
        byte b0 = addr[0];
        byte b1 = addr[1];
        int section01 = 10;
        int section02 = -84;
        int section03 = 16;
        int section04 = 31;
        int section05 = -64;
        int section06 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                if (b1 != -88) break;
                return true;
            }
        }
        return false;
    }

    public static String getHostIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.error("\u83b7\u53d6ip\u5730\u5740\u5931\u8d25:{}", (Object)e.getMessage());
            return LOCAL_HOST;
        }
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error("\u83b7\u53d6host name\u5931\u8d25:{}", (Object)e.getMessage());
            return UNKNOWN;
        }
    }

    public static UserAgentInfo userAgent(HttpServletRequest request) {
        UserAgentInfo agent = new UserAgentInfo();
        String userAgent = request.getHeader("User-Agent");
        Capabilities capabilities = SystemConfig.PARSER.parse(userAgent);
        agent.setBrowser(OsUtil.formatUserAgent(capabilities.getBrowser(), capabilities.getBrowserMajorVersion()));
        agent.setPlatform(OsUtil.formatUserAgent(capabilities.getPlatform(), capabilities.getPlatformVersion()));
        return agent;
    }

    private static String formatUserAgent(String name, String version) {
        CharSequence[] searchStrings = new String[]{"0", UNKNOWN};
        if (StringUtils.equalsAny((CharSequence)version, (CharSequence[])searchStrings)) {
            return name;
        }
        return String.format("%s(%s)", name, version);
    }

    public static byte[] textToNumericFormatV4(String src) {
        byte[] res = new byte[4];
        long tmpValue = 0L;
        int currByte = 0;
        boolean newOctet = true;
        int len = src.length();
        int ipLen = 15;
        if (len == 0 || len > ipLen) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (c == '.') {
                if (newOctet || tmpValue < 0L || tmpValue > 255L || currByte == 3) {
                    return null;
                }
                res[currByte++] = (byte)(tmpValue & 0xFFL);
                tmpValue = 0L;
                newOctet = true;
                continue;
            }
            int digit = Character.digit(c, 10);
            if (digit < 0) {
                return null;
            }
            tmpValue *= 10L;
            tmpValue += (long)digit;
            newOctet = false;
        }
        int min = 4;
        int max = 8;
        if (newOctet || tmpValue < 0L || tmpValue >= 1L << (min - currByte) * max) {
            return null;
        }
        switch (currByte) {
            case 0: {
                res[0] = (byte)(tmpValue >> 24 & 0xFFL);
                break;
            }
            case 1: {
                res[1] = (byte)(tmpValue >> 16 & 0xFFL);
                break;
            }
            case 2: {
                res[2] = (byte)(tmpValue >> 8 & 0xFFL);
                break;
            }
            case 3: {
                res[3] = (byte)(tmpValue & 0xFFL);
                break;
            }
        }
        return res;
    }
}

