/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.model.StandardSm2Engine;
import cn.sinozg.applet.common.utils.PojoUtil;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmUtil {
    private static final String EC = "EC";
    private static final String STD_NAME = "sm2p256v1";
    public static final String ALGORITHM_SM4 = "SM4";
    private static final int DEFAULT_KEY_SIZE = 128;
    public static final String ALGORITHM_NAME_ECB_PADDING5 = "SM4/ECB/PKCS5Padding";
    public static final String ALGORITHM_NAME_ECB_PADDING7 = "SM4/ECB/PKCS7Padding";
    private static final BouncyCastleProvider BOUNCY = new BouncyCastleProvider();
    private static final Logger LOG = LoggerFactory.getLogger(SmUtil.class);

    public static String signSm2(String plainText, String privateKey) {
        try {
            Signature rsaSignature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)BOUNCY);
            PrivateKey key = (PrivateKey)SmUtil.sm2Key(privateKey, false, true);
            rsaSignature.initSign(key);
            rsaSignature.update(plainText.getBytes());
            byte[] signed = rsaSignature.sign();
            return Base64.encodeBase64String((byte[])signed);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verifySm2(String plainText, String signature, String publicKey) {
        try {
            Signature sign = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)BOUNCY);
            PublicKey pk = (PublicKey)SmUtil.sm2Key(publicKey, true, true);
            sign.initVerify(pk);
            sign.update(Hex.decodeHex((char[])plainText.toCharArray()));
            return sign.verify(Hex.decodeHex((char[])signature.toCharArray()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException | DecoderException e) {
            LOG.error("\u9a8c\u7b7e\u5931\u8d25", e);
            return false;
        }
    }

    public static String encryptSm2(String plainText, String publicKey) {
        byte[] decryptData = SmUtil.sm2(plainText, publicKey, true);
        return Base64.encodeBase64String((byte[])decryptData);
    }

    public static String decryptSm2(String input, String privateKey) {
        byte[] decryptData = SmUtil.sm2(input, privateKey, false);
        return new String(decryptData);
    }

    public static KeyPair keyPairSm2() {
        try {
            ECGenParameterSpec sm2Spec = new ECGenParameterSpec(STD_NAME);
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(EC, (Provider)BOUNCY);
            SecureRandom random = new SecureRandom();
            kpg.initialize(sm2Spec, random);
            return kpg.generateKeyPair();
        }
        catch (Exception e) {
            LOG.error("generate sm2 key pair failed:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static String encryptPlusSm3(String params, String key) {
        byte[] srcData = params.getBytes(StandardCharsets.UTF_8);
        byte[] resultHash = SmUtil.hmac(srcData, key.getBytes(StandardCharsets.UTF_8));
        return Hex.encodeHexString((byte[])resultHash);
    }

    public static String encryptSm3(String params) {
        byte[] srcData = params.getBytes(StandardCharsets.UTF_8);
        byte[] resultHash = SmUtil.sm3Hash(srcData);
        return Hex.encodeHexString((byte[])resultHash);
    }

    public static boolean matchesSm3(String input, String encodedParams) {
        try {
            byte[] srcData = input.getBytes(StandardCharsets.UTF_8);
            byte[] sm3Hash = Hex.decodeHex((String)encodedParams);
            byte[] newHash = SmUtil.sm3Hash(srcData);
            return Arrays.equals(newHash, sm3Hash);
        }
        catch (Exception e) {
            LOG.error("sm3\u5bf9\u6bd4\u5931\u8d25 ", (Throwable)e);
            return false;
        }
    }

    public static String encryptSm4(String plainText, String key) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(SmUtil.sm4Key(key), ALGORITHM_SM4);
            Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_ECB_PADDING7, "BC");
            cipher.init(1, secretKeySpec);
            byte[] cipherBytes = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
            return Base64.encodeBase64String((byte[])cipherBytes);
        }
        catch (Exception e) {
            LOG.error("SM4 \u52a0\u5bc6\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] decryptSm4(String cipherString, String key) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(SmUtil.sm4Key(key), ALGORITHM_SM4);
            Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_ECB_PADDING7, "BC");
            cipher.init(2, secretKeySpec);
            return cipher.doFinal(Base64.decodeBase64((String)cipherString));
        }
        catch (Exception e) {
            LOG.error("SM4 \u89e3\u5bc6\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String generateKeySm4() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_SM4, "BC");
        kg.init(128, new SecureRandom());
        return Hex.encodeHexString((byte[])kg.generateKey().getEncoded());
    }

    private static byte[] sm4Key(String key) throws NoSuchAlgorithmException {
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] hash = sha256.digest(key.getBytes(StandardCharsets.UTF_8));
        byte[] kbs = new byte[16];
        System.arraycopy(hash, 0, kbs, 0, 16);
        return kbs;
    }

    private static byte[] sm2(Object in, String key, boolean encrypt) {
        try {
            AsymmetricKeyParameter cipherParameters;
            byte[] bs;
            if (in instanceof byte[]) {
                byte[] ins;
                bs = ins = (byte[])in;
            } else {
                String plainText = in.toString();
                byte[] byArray = bs = encrypt ? plainText.toLowerCase().getBytes(StandardCharsets.UTF_8) : Base64.decodeBase64((String)plainText);
            }
            if (encrypt) {
                cipherParameters = ECUtil.generatePublicKeyParameter((PublicKey)((PublicKey)SmUtil.sm2Key(key, encrypt, false)));
                cipherParameters = new ParametersWithRandom((CipherParameters)cipherParameters);
            } else {
                cipherParameters = ECUtil.generatePrivateKeyParameter((PrivateKey)((PrivateKey)SmUtil.sm2Key(key, encrypt, false)));
            }
            StandardSm2Engine engine = new StandardSm2Engine((Digest)new SM3Digest(), SM2Engine.Mode.C1C3C2);
            engine.init(true, (CipherParameters)cipherParameters);
            return engine.processBlock(bs, 0, bs.length);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | InvalidCipherTextException e) {
            LOG.error("sm2 {} \u52a0\u89e3\u5bc6{}\u9519\u8bef", new Object[]{in, encrypt, e});
            throw new RuntimeException(e);
        }
    }

    private static <T extends Key> T sm2Key(String key, boolean pub, boolean signature) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Key k;
        KeyFactory factory;
        byte[] pkd = Base64.decodeBase64((String)key);
        KeyFactory keyFactory = factory = signature ? KeyFactory.getInstance(EC, (Provider)BOUNCY) : KeyFactory.getInstance(EC);
        if (pub) {
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(pkd);
            k = factory.generatePublic(publicKeySpec);
        } else {
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(pkd);
            k = factory.generatePrivate(privateKeySpec);
        }
        return (T)((Key)PojoUtil.cast((Object)k));
    }

    private static byte[] sm3Hash(byte[] params) {
        SM3Digest digest = new SM3Digest();
        digest.update(params, 0, params.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return hash;
    }

    private static byte[] hmac(byte[] key, byte[] input) {
        KeyParameter keyParameter = new KeyParameter(key);
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac((Digest)digest);
        mac.init((CipherParameters)keyParameter);
        mac.update(input, 0, input.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

