/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * 请求分页信息
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-14 下午 09:35
 **/
public class PagingRequest {

    /** 分页当前页 */
    @JsonProperty("pageNum")
    @Schema(description = "分页当前页")
    private Long pageNum;

    /** 分页大小 */
    @JsonProperty("pageSize")
    @Schema(description = "分页大小")
    private Long pageSize;

    /**
     * 获取 分页当前页
     *
     * @return pageNum 分页当前页
     */
    public Long getPageNum() {
        if (pageNum == null) {
            pageNum = 10L;
        }
        return pageNum;
    }

    /**
     * 设置 分页当前页
     *
     * @param pageNum 分页当前页
     */
    public void setPageNum(Long pageNum) {
        this.pageNum = pageNum;
    }

    /**
     * 获取 分页大小
     *
     * @return pageSize 分页大小
     */
    public Long getPageSize() {
        if (pageSize == null) {
            pageSize = 10L;
        }
        return pageSize;
    }

    /**
     * 设置 分页大小
     *
     * @param pageSize 分页大小
     */
    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }
}
