/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.properties;

import java.util.List;

/**
 * 租户配置
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-29 下午 05:07
 **/
public class TenantValue {

    /** 是否开启 */
    private boolean enable;

    /** 开启过期检查 */
    private boolean expiredCheck;

    /** 请求拦截 自定义的拦截器 路径 */
    private List<String> checkExcludePath;

    /** 忽略的表名称 */
    private List<String> tables;

    /**
     * 获取 是否开启
     *
     * @return enable 是否开启
     */
    public boolean isEnable() {
        return this.enable;
    }

    /**
     * 设置 是否开启
     *
     * @param enable 是否开启
     */
    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    /**
     * 获取 开启过期检查
     *
     * @return expiredCheck 开启过期检查
     */
    public boolean isExpiredCheck() {
        return this.expiredCheck;
    }

    /**
     * 设置 开启过期检查
     *
     * @param expiredCheck 开启过期检查
     */
    public void setExpiredCheck(boolean expiredCheck) {
        this.expiredCheck = expiredCheck;
    }

    /**
     * 获取 请求拦截 自定义的拦截器 路径
     *
     * @return checkExcludePath 请求拦截 自定义的拦截器 路径
     */
    public List<String> getCheckExcludePath() {
        return this.checkExcludePath;
    }

    /**
     * 设置 请求拦截 自定义的拦截器 路径
     *
     * @param checkExcludePath 请求拦截 自定义的拦截器 路径
     */
    public void setCheckExcludePath(List<String> checkExcludePath) {
        this.checkExcludePath = checkExcludePath;
    }

    /**
     * 获取 忽略的表名称
     *
     * @return tables 忽略的表名称
     */
    public List<String> getTables() {
        return this.tables;
    }

    /**
     * 设置 忽略的表名称
     *
     * @param tables 忽略的表名称
     */
    public void setTables(List<String> tables) {
        this.tables = tables;
    }
}