/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-12-11 21:26
 */
public class I18nBaseUtil {
    /** 西班牙语 */
    protected static final Locale ES = new Locale("es", "ES");

    /**
     * 支持的语言
     * @return 语言
     */
    public static List<Locale> supportLocales(){
        List<Locale> locales = new ArrayList<>();
        locales.add(Locale.CHINA);
        locales.add(Locale.US);
        locales.add(Locale.FRANCE);
        locales.add(ES);
        locales.add(Locale.JAPAN);
        return locales;
    }
}
