/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.config.SystemConfig;
import org.apache.commons.lang3.StringUtils;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-05 20:07
 */
public class StringUtil {

    private StringUtil(){
    }
    /**
     * 根据图片id转为直接显示的地址
     * @param picId 图片id
     * @return 显示地址
     */
    public static String showUrl (String picId){
        if (StringUtils.isEmpty(picId)) {
            return null;
        }
        String host = SystemConfig.APP.getFontUrl();
        if (StringUtils.contains(picId, host)) {
            return picId;
        }
        return host + picId;
    }

    /**
     * 删除最后一个字符
     * @param input 参数
     */
    public static void delLast(StringBuilder input){
        if (!input.isEmpty()) {
            input.deleteCharAt(input.length() - 1);
        }
    }
}
