/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import jakarta.validation.constraints.NotNull;

/**
 * 通用请求 传入id集合
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-14 下午 10:38
 **/
public class ComIds {
    /** id */
    @Schema(description = "id集合")
    @NotNull(message = "{TIRSCI.ComIds.ids}")
    private List<String> ids;

    /**
     * 获取 id
     *
     * @return ids id
     */
    public List<String> getIds() {
        return this.ids;
    }

    /**
     * 设置 id
     *
     * @param ids id
     */
    public void setIds(List<String> ids) {
        this.ids = ids;
    }
}