/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.service.impl;

import cn.sinozg.applet.common.core.model.RequestParameterEncrypt;
import cn.sinozg.applet.common.service.CipherService;
import cn.sinozg.applet.common.utils.CypherUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.stereotype.Service;

/**
 * 默认实现加密
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-12-04 14:13
 */
@Service
@ConditionalOnSingleCandidate(value = CipherService.class)
public class CipherDefaultServiceImpl implements CipherService {

    @Override
    public String encoder(CharSequence plainText) {
        return CypherUtil.encoder(plainText.toString());
    }

    @Override
    public boolean matches(CharSequence plainText, String encodedPassword) {
        return CypherUtil.matches(plainText, encodedPassword);
    }

    @Override
    public boolean signature(boolean sha2, String signature, String... params) {
        return CypherUtil.signature(sha2, signature, params);
    }

    @Override
    public byte[] decryptJson(String content, String asymmetricPrivateKey, String symmetricEncrypt) throws Exception {
        return CypherUtil.decryptJson(content, asymmetricPrivateKey, symmetricEncrypt);
    }

    @Override
    public RequestParameterEncrypt encrypt(String content, String symmetricPublicKey) throws Exception {
        return CypherUtil.encrypt(content, symmetricPublicKey);
    }
}
