/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.config;

import cn.sinozg.applet.common.constant.OmConstants;
import cn.sinozg.applet.common.handler.SslSocket;
import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.properties.CrtValue;
import cn.sinozg.applet.common.service.FrameworkInitDataService;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.blueconic.browscap.BrowsCapField;
import com.blueconic.browscap.UserAgentParser;
import com.blueconic.browscap.UserAgentService;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * 系统静态参数
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-14 下午 09:29
 **/
@Component
public class SystemConfig {
    @Resource
    public AppValue appValue;
    @Resource
    public ObjectMapper objectMapper;
    @Resource
    private FrameworkInitDataService initDataService;

    public static final Logger log = LoggerFactory.getLogger(SystemConfig.class);
    /** 系统配置 */
    public static AppValue APP;

    /** 解析浏览器的信息 */
    public static UserAgentParser PARSER;

    @PostConstruct
    public void init(){
        OmConstants.setOm(objectMapper);
        // 设置mp 的序列化实现
        JacksonTypeHandler.setObjectMapper(objectMapper);
        APP = appValue;
        try {
            // 加载配置信息 有点慢 所以用静态变量
            List<BrowsCapField> fields = Arrays.asList(BrowsCapField.BROWSER, BrowsCapField.BROWSER_MAJOR_VERSION, BrowsCapField.PLATFORM, BrowsCapField.PLATFORM_VERSION);
            PARSER = new UserAgentService().loadParser(fields);
            httpCrt(appValue.getCrt());
        } catch (Exception ignored) {
        }
        initDataService.postConstruct();
    }

    /**
     * 设置 http请求的证书信息
     * @param crt 证书
     */
    private void httpCrt(CrtValue crt){
        List<String> crtPath = null;
        if (crt.getPaths() != null) {
            crtPath = crt.getPaths();
        }
        if (StringUtils.isNotBlank(crt.getFolder())) {
            File file = new File(crt.getFolder());
            if (file.isDirectory() && file.listFiles() != null) {
                File[] fs = file.listFiles();
                if (fs != null) {
                    if (crtPath == null) {
                        crtPath = new ArrayList<>();
                    }
                    for (File f : fs) {
                        if (f.isFile()) {
                            crtPath.add(f.getAbsolutePath());
                        }
                    }
                }
            }
        }
        SslSocket.CRT = crtPath;
    }
}
