/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * 请求响应信息基类
 * @Author: xyb
 * @Description: 
 * @Date: 2022-11-14 下午 09:35
 **/
public class BaseResponse<T> {
	/**
	 * 交易状态
	 * 00-成功
	 * 01-失败
	 */
	@JsonProperty("bizStatus")
	@Schema(description = "交易状态;00-成功 01-失败")
	private String bizStatus;

	/** 链路 跟踪 id */
	@JsonProperty("traceId")
	@Schema(description = "链路 跟踪 id")
	private String traceId;
	
	/** 错误信息描述 */
	@JsonProperty("errorInfo")
	@Schema(description = "错误信息描述")
	private ErrorInfo errorInfo;
	/** 业务数据 */
	@JsonProperty("data")
	@Schema(description = "业务数据")
	private T data;

	/**
	 * 获取 交易状态  00-成功  01-失败
	 *
	 * @return bizStatus 交易状态  00-成功  01-失败
	 */
	public String getBizStatus() {
		return this.bizStatus;
	}

	/**
	 * 设置 交易状态  00-成功  01-失败
	 *
	 * @param bizStatus 交易状态  00-成功  01-失败
	 */
	public void setBizStatus(String bizStatus) {
		this.bizStatus = bizStatus;
	}

	/**
	 * 获取 链路 跟踪 id
	 *
	 * @return traceId 链路 跟踪 id
	 */
	public String getTraceId() {
		return this.traceId;
	}

	/**
	 * 设置 链路 跟踪 id
	 *
	 * @param traceId 链路 跟踪 id
	 */
	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	/**
	 * 获取 错误信息描述
	 *
	 * @return errorInfo 错误信息描述
	 */
	public ErrorInfo getErrorInfo() {
		return this.errorInfo;
	}

	/**
	 * 设置 错误信息描述
	 *
	 * @param errorInfo 错误信息描述
	 */
	public void setErrorInfo(ErrorInfo errorInfo) {
		this.errorInfo = errorInfo;
	}

	/**
	 * 获取 业务数据
	 *
	 * @return data 业务数据
	 */
	public T getData() {
		return this.data;
	}

	/**
	 * 设置 业务数据
	 *
	 * @param data 业务数据
	 */
	public void setData(T data) {
		this.data = data;
	}
}
