/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.model;

import io.swagger.v3.oas.annotations.media.Schema;


/**
 * 字典数据表表
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-14 下午 09:39
 **/
@Schema(name = "DictDataVo", description = "字典数据表")
public class DictDataVo {

    /** 字典编码 */
    @Schema(description = "字典编码")
    private String id;

    /** 字典排序 */
    @Schema(description = "字典排序")
    private Integer dictSort;

    /** 字典标签 */
    @Schema(description = "字典标签")
    private String dictLabel;

    /** 编码名称 */
    @Schema(description = "编码名称")
    private I18nName i18nLabel;

    /** 字典键值 */
    @Schema(description = "字典键值")
    private String dictValue;

    /** 字典类型 */
    @Schema(description = "字典类型")
    private String dictType;

    /** 样式属性（其他样式扩展） */
    @Schema(description = "样式属性（其他样式扩展）")
    private String cssClass;

    /** 表格回显样式 */
    @Schema(description = "表格回显样式")
    private String listClass;

    /** 是否默认（Y是 N否） */
    @Schema(description = "是否默认（Y是 N否）")
    private String isDefault;

    /**
     * 获取 字典编码
     *
     * @return id 字典编码
     */
    public String getId() {
        return this.id;
    }

    /**
     * 设置 字典编码
     *
     * @param id 字典编码
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取 字典排序
     *
     * @return dictSort 字典排序
     */
    public Integer getDictSort() {
        return this.dictSort;
    }

    /**
     * 设置 字典排序
     *
     * @param dictSort 字典排序
     */
    public void setDictSort(Integer dictSort) {
        this.dictSort = dictSort;
    }

    /**
     * 获取 字典标签
     *
     * @return dictLabel 字典标签
     */
    public String getDictLabel() {
        return this.dictLabel;
    }

    /**
     * 设置 字典标签
     *
     * @param dictLabel 字典标签
     */
    public void setDictLabel(String dictLabel) {
        this.dictLabel = dictLabel;
    }

    /**
     * 获取 编码名称
     *
     * @return i18nLabel 编码名称
     */
    public I18nName getI18nLabel() {
        return this.i18nLabel;
    }

    /**
     * 设置 编码名称
     *
     * @param i18nLabel 编码名称
     */
    public void setI18nLabel(I18nName i18nLabel) {
        this.i18nLabel = i18nLabel;
    }

    /**
     * 获取 字典键值
     *
     * @return dictValue 字典键值
     */
    public String getDictValue() {
        return this.dictValue;
    }

    /**
     * 设置 字典键值
     *
     * @param dictValue 字典键值
     */
    public void setDictValue(String dictValue) {
        this.dictValue = dictValue;
    }

    /**
     * 获取 字典类型
     *
     * @return dictType 字典类型
     */
    public String getDictType() {
        return this.dictType;
    }

    /**
     * 设置 字典类型
     *
     * @param dictType 字典类型
     */
    public void setDictType(String dictType) {
        this.dictType = dictType;
    }

    /**
     * 获取 样式属性（其他样式扩展）
     *
     * @return cssClass 样式属性（其他样式扩展）
     */
    public String getCssClass() {
        return this.cssClass;
    }

    /**
     * 设置 样式属性（其他样式扩展）
     *
     * @param cssClass 样式属性（其他样式扩展）
     */
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    /**
     * 获取 表格回显样式
     *
     * @return listClass 表格回显样式
     */
    public String getListClass() {
        return this.listClass;
    }

    /**
     * 设置 表格回显样式
     *
     * @param listClass 表格回显样式
     */
    public void setListClass(String listClass) {
        this.listClass = listClass;
    }

    /**
     * 获取 是否默认（Y是 N否）
     *
     * @return isDefault 是否默认（Y是 N否）
     */
    public String getIsDefault() {
        return this.isDefault;
    }

    /**
     * 设置 是否默认（Y是 N否）
     *
     * @param isDefault 是否默认（Y是 N否）
     */
    public void setIsDefault(String isDefault) {
        this.isDefault = isDefault;
    }
}
