/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 加密信息对象
 * @Author: xyb
 * @Description:
 * @Date: 2023-04-22 下午 03:40
 **/
public class RequestParameterEncrypt {

    /** 加密后的json数据 */
    @JsonProperty(value = "data")
    private String data;

    /** 对称加密后的数据 */
    @JsonProperty(value = "encrypt")
    private String symmetricEncrypt;

    /**
     * 获取 加密后的json数据
     *
     * @return data 加密后的json数据
     */
    public String getData() {
        return this.data;
    }

    /**
     * 设置 加密后的json数据
     *
     * @param data 加密后的json数据
     */
    public void setData(String data) {
        this.data = data;
    }

    /**
     * 获取 对称加密后的数据
     *
     * @return symmetricEncrypt 对称加密后的数据
     */
    public String getSymmetricEncrypt() {
        return this.symmetricEncrypt;
    }

    /**
     * 设置 对称加密后的数据
     *
     * @param symmetricEncrypt 对称加密后的数据
     */
    public void setSymmetricEncrypt(String symmetricEncrypt) {
        this.symmetricEncrypt = symmetricEncrypt;
    }
}