/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;

/**
 * 角色信息
 * @Author: xyb
 * @Description
 * @Date: 2022/9/14 14:00
 */
public class RoleInfoVo implements Serializable {
    /** 用户ID */
    @Schema(description = "用户ID")
    private String roleKey;
    /** 数据权限范围 */
    private String dataScope;
    /** 橘色ID */
    private String roleId;

    /**
     * 获取 用户ID
     *
     * @return roleKey 用户ID
     */
    public String getRoleKey() {
        return this.roleKey;
    }

    /**
     * 设置 用户ID
     *
     * @param roleKey 用户ID
     */
    public void setRoleKey(String roleKey) {
        this.roleKey = roleKey;
    }

    /**
     * 获取 数据权限范围
     *
     * @return dataScope 数据权限范围
     */
    public String getDataScope() {
        return this.dataScope;
    }

    /**
     * 设置 数据权限范围
     *
     * @param dataScope 数据权限范围
     */
    public void setDataScope(String dataScope) {
        this.dataScope = dataScope;
    }

    /**
     * 获取 橘色ID
     *
     * @return roleId 橘色ID
     */
    public String getRoleId() {
        return this.roleId;
    }

    /**
     * 设置 橘色ID
     *
     * @param roleId 橘色ID
     */
    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }
}
