/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.service.impl;

import cn.sinozg.applet.common.core.model.LoginUserVo;
import cn.sinozg.applet.common.service.FrameworkUserService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.stereotype.Service;

/**
 * 默认实现用户信息
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-05 17:41
 */
@Service
@ConditionalOnSingleCandidate(value = FrameworkUserService.class)
public class DefaultFrameworkUserServiceImpl implements FrameworkUserService {
    @Override
    public LoginUserVo refreshUserInfo() {
        return null;
    }

    @Override
    public LoginUserVo userInfo() {
        return null;
    }

    @Override
    public LoginUserVo setUserInfo(String token, String uid, LoginUserVo user) {
        return null;
    }

    @Override
    public LoginUserVo getUserInfo(String token, String uid) {
        return null;
    }
}
